/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import jodd.typeconverter.Convert;

public class LoggablePreparedStatement
implements PreparedStatement {
    protected ArrayList<String> parameterValues;
    protected String sqlTemplate;
    protected PreparedStatement wrappedStatement;

    public LoggablePreparedStatement(Connection connection, String sql) throws SQLException {
        this.wrappedStatement = connection.prepareStatement(sql);
        this.sqlTemplate = sql;
        this.parameterValues = new ArrayList();
    }

    public LoggablePreparedStatement(Connection connection, String sql, int resultType, int resultSetConcurrency) throws SQLException {
        this.wrappedStatement = connection.prepareStatement(sql, resultType, resultSetConcurrency);
        this.sqlTemplate = sql;
        this.parameterValues = new ArrayList();
    }

    public LoggablePreparedStatement(Connection connection, String sql, int resultType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.wrappedStatement = connection.prepareStatement(sql, resultType, resultSetConcurrency, resultSetHoldability);
        this.sqlTemplate = sql;
        this.parameterValues = new ArrayList();
    }

    public LoggablePreparedStatement(Connection connection, String sql, int generateKeys) throws SQLException {
        this.wrappedStatement = connection.prepareStatement(sql, generateKeys);
        this.sqlTemplate = sql;
        this.parameterValues = new ArrayList();
    }

    public LoggablePreparedStatement(Connection connection, String sql, String[] columnNames) throws SQLException {
        this.wrappedStatement = connection.prepareStatement(sql, columnNames);
        this.sqlTemplate = sql;
        this.parameterValues = new ArrayList();
    }

    public void addBatch() throws SQLException {
        this.wrappedStatement.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.wrappedStatement.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.wrappedStatement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.wrappedStatement.clearBatch();
    }

    public void clearParameters() throws SQLException {
        this.wrappedStatement.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.wrappedStatement.clearWarnings();
    }

    public void close() throws SQLException {
        this.wrappedStatement.close();
    }

    public boolean execute() throws SQLException {
        return this.wrappedStatement.execute();
    }

    public boolean execute(String sql) throws SQLException {
        return this.wrappedStatement.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        return this.wrappedStatement.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.wrappedStatement.executeQuery();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.wrappedStatement.executeQuery(sql);
    }

    public int executeUpdate() throws SQLException {
        return this.wrappedStatement.executeUpdate();
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql);
    }

    public Connection getConnection() throws SQLException {
        return this.wrappedStatement.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.wrappedStatement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.wrappedStatement.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.wrappedStatement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.wrappedStatement.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.wrappedStatement.getMetaData();
    }

    public boolean getMoreResults() throws SQLException {
        return this.wrappedStatement.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this.wrappedStatement.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.wrappedStatement.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.wrappedStatement.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.wrappedStatement.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.wrappedStatement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.wrappedStatement.getWarnings();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.wrappedStatement.setArray(i, x);
        this.saveQueryParamValueName(i, "Array", -1L);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrappedStatement.setAsciiStream(parameterIndex, x, length);
        this.saveQueryParamValueName(parameterIndex, "AsciiStream", -1L);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.wrappedStatement.setBigDecimal(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrappedStatement.setBinaryStream(parameterIndex, x, length);
        this.saveQueryParamValueName(parameterIndex, "BinaryStream", length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.wrappedStatement.setBlob(i, x);
        this.saveQueryParamValueName(i, "Blob", -1L);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.wrappedStatement.setBoolean(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.wrappedStatement.setByte(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.wrappedStatement.setBytes(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.wrappedStatement.setCharacterStream(parameterIndex, reader, length);
        this.saveQueryParamValueName(parameterIndex, "CharacterStream", length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.wrappedStatement.setClob(i, x);
        this.saveQueryParamValueName(i, "Clob", -1L);
    }

    public void setCursorName(String name) throws SQLException {
        this.wrappedStatement.setCursorName(name);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.wrappedStatement.setDate(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.wrappedStatement.setDate(parameterIndex, x, cal);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.wrappedStatement.setDouble(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.wrappedStatement.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.wrappedStatement.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.wrappedStatement.setFetchSize(rows);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.wrappedStatement.setFloat(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, Float.valueOf(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.wrappedStatement.setInt(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.wrappedStatement.setLong(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.wrappedStatement.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.wrappedStatement.setMaxRows(max);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.wrappedStatement.setNull(parameterIndex, sqlType);
        this.saveQueryParamValue(parameterIndex, null);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.wrappedStatement.setNull(parameterIndex, sqlType, typeName);
        this.saveQueryParamValue(parameterIndex, null);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.wrappedStatement.setObject(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.wrappedStatement.setObject(parameterIndex, x, targetSqlType);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.wrappedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.wrappedStatement.setQueryTimeout(seconds);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.wrappedStatement.setRef(i, x);
        this.saveQueryParamValueName(i, "Ref", -1L);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.wrappedStatement.setShort(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.wrappedStatement.setString(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.wrappedStatement.setTime(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.wrappedStatement.setTime(parameterIndex, x, cal);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.wrappedStatement.setTimestamp(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.wrappedStatement.setTimestamp(parameterIndex, x, cal);
        this.saveQueryParamValue(parameterIndex, x);
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrappedStatement.setUnicodeStream(parameterIndex, x, length);
        this.saveQueryParamValueName(parameterIndex, "UnicodeStream", length);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.wrappedStatement.setURL(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.wrappedStatement.getParameterMetaData();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.wrappedStatement.getResultSetHoldability();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.wrappedStatement.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.wrappedStatement.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrappedStatement.execute(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql, columnIndexes);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.wrappedStatement.execute(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.wrappedStatement.execute(sql, columnNames);
    }

    public String getQueryString() {
        StringBuilder buf = new StringBuilder();
        int qMarkCount = 0;
        StringTokenizer tok = new StringTokenizer(this.sqlTemplate + ' ', "?");
        while (tok.hasMoreTokens()) {
            String oneChunk = tok.nextToken();
            buf.append(oneChunk);
            try {
                String value;
                if (this.parameterValues.size() > 1 + qMarkCount) {
                    value = this.parameterValues.get(1 + qMarkCount);
                    ++qMarkCount;
                } else {
                    value = tok.hasMoreTokens() ? null : "";
                }
                buf.append((Object)value);
            }
            catch (Throwable th) {
                buf.append("--- Exception occurs while creating query string for log: ").append(th.toString());
            }
        }
        return buf.toString().trim();
    }

    protected void saveQueryParamValueName(int position, String str, long len) {
        if (len == -1L) {
            this.saveQueryParamValue(position, '<' + str + '>');
        } else {
            this.saveQueryParamValue(position, '<' + str + ", len=" + len + '>');
        }
    }

    protected void saveQueryParamValue(int position, Object obj) {
        String strValue = obj instanceof String || obj instanceof java.util.Date ? "'" + obj + '\'' : (obj == null ? "<null>" : Convert.toString((Object)obj));
        while (position >= this.parameterValues.size()) {
            this.parameterValues.add(null);
        }
        this.parameterValues.set(position, strValue);
    }
}

