/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.servlet.HtmlDecoder;
import jodd.servlet.HtmlEncoder;
import jodd.util.StringUtil;

public class Attribute
implements Cloneable {
    protected final String name;
    protected final int nameHash;
    protected String value;
    protected String[] splits;

    public Attribute(String name, String value, boolean decode) {
        this.name = name;
        this.nameHash = name.hashCode();
        this.value = value != null ? (decode ? HtmlDecoder.decode((String)value) : value) : null;
    }

    public Attribute clone() {
        return new Attribute(this.name, this.value, false);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equalsName(String name, int nameHash) {
        return this.nameHash == nameHash && this.name.equals(name);
    }

    public void toHtml(Appendable appendable) throws IOException {
        appendable.append(this.name);
        if (this.value != null) {
            appendable.append('=');
            appendable.append('\"');
            appendable.append(HtmlEncoder.text((String)this.value));
            appendable.append('\"');
        }
    }

    public boolean isIncluding(String include) {
        if (this.value == null) {
            return false;
        }
        if (this.splits == null) {
            this.splits = StringUtil.splitc((String)this.value, (char)' ');
        }
        for (String s : this.splits) {
            if (!s.equals(include)) continue;
            return true;
        }
        return false;
    }
}

