/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.Iterator;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.mapper.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbListIterator<T>
implements Iterator<T> {
    protected DbOomQuery query;
    protected ResultSetMapper resultSetMapper;
    protected boolean closeOnEnd;
    protected Class[] types;
    protected boolean one;

    DbListIterator(DbOomQuery query, Class[] types) {
        this(query, types, true);
    }

    DbListIterator(DbOomQuery query, Class[] types, boolean closeOnEnd) {
        this.query = query;
        this.resultSetMapper = query.executeAndBuildResultSetMapper();
        this.types = types == null ? this.resultSetMapper.resolveTables() : types;
        this.closeOnEnd = closeOnEnd;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing is not supported.");
    }

    @Override
    public boolean hasNext() {
        if (this.resultSetMapper.next()) {
            return true;
        }
        if (this.closeOnEnd) {
            this.query.close();
        } else {
            this.query.closeResultSet(this.resultSetMapper.getResultSet());
        }
        return false;
    }

    @Override
    public T next() {
        return (T)this.query.resolveRowHints(this.resultSetMapper.parseObjects(this.types));
    }
}

