/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import jodd.util.HashCode;

public class DbTransactionMode {
    public static final int ISOLATION_DEFAULT = -1;
    public static final int ISOLATION_NONE = 0;
    public static final int ISOLATION_READ_UNCOMMITTED = 1;
    public static final int ISOLATION_READ_COMMITTED = 2;
    public static final int ISOLATION_REPEATABLE_READ = 4;
    public static final int ISOLATION_SERIALIZABLE = 8;
    private int isolation = -1;
    public static final boolean READ_ONLY = true;
    public static final boolean READ_WRITE = false;
    private boolean readOnlyMode = true;

    public int getIsolation() {
        return this.isolation;
    }

    public void setIsolation(int isolation) {
        this.isolation = isolation;
    }

    public DbTransactionMode isolationNone() {
        this.isolation = 0;
        return this;
    }

    public DbTransactionMode isolationReadUncommitted() {
        this.isolation = 1;
        return this;
    }

    public DbTransactionMode isolationReadCommited() {
        this.isolation = 2;
        return this;
    }

    public DbTransactionMode isolationRepeatableRead() {
        this.isolation = 4;
        return this;
    }

    public DbTransactionMode isolationSerializable() {
        this.isolation = 8;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public DbTransactionMode setReadOnly(boolean readOnly) {
        this.readOnlyMode = readOnly;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DbTransactionMode)) {
            return false;
        }
        DbTransactionMode mode = (DbTransactionMode)object;
        return mode.getIsolation() == this.isolation && mode.isReadOnly() == this.readOnlyMode;
    }

    public int hashCode() {
        int result = 173;
        result = HashCode.hash((int)result, (boolean)this.readOnlyMode);
        result = HashCode.hash((int)result, (int)this.isolation);
        return result;
    }
}

