/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.io.FileNameUtil;
import jodd.servlet.ServletUtil;
import jodd.servlet.filter.GzipResponseWrapper;
import jodd.typeconverter.Converter;
import jodd.typeconverter.TypeConversionException;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public class GzipFilter
implements Filter {
    protected int threshold;
    protected String[] matches;
    protected String[] excludes;
    protected boolean wildcards;
    protected String requestParameterName;
    protected String[] extensions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.threshold == 0 || !ServletUtil.isGzipSupported(req) || !this.isGzipEligible(req)) {
            chain.doFilter(request, response);
            return;
        }
        GzipResponseWrapper wrappedResponse = new GzipResponseWrapper(res);
        wrappedResponse.setCompressionThreshold(this.threshold);
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedResponse.finishResponse();
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String uriExclude;
        try {
            this.wildcards = Converter.get().toBooleanValue((Object)config.getInitParameter("wildcards"), false);
        }
        catch (TypeConversionException ignore) {
            this.wildcards = false;
        }
        try {
            this.threshold = Converter.get().toIntValue((Object)config.getInitParameter("threshold"), 0);
        }
        catch (TypeConversionException ignore) {
            this.threshold = 0;
        }
        String uriMatch = config.getInitParameter("match");
        if (uriMatch != null && !uriMatch.equals("*")) {
            this.matches = StringUtil.splitc((String)uriMatch, (char)',');
            for (int i = 0; i < this.matches.length; ++i) {
                this.matches[i] = this.matches[i].trim();
            }
        }
        if ((uriExclude = config.getInitParameter("exclude")) != null) {
            this.excludes = StringUtil.splitc((String)uriExclude, (char)',');
            for (int i = 0; i < this.excludes.length; ++i) {
                this.excludes[i] = this.excludes[i].trim();
            }
        }
        this.requestParameterName = config.getInitParameter("requestParameterName");
        if (this.requestParameterName == null) {
            this.requestParameterName = "gzip";
        }
        this.requestParameterName = this.requestParameterName.trim();
        String urlExtensions = config.getInitParameter("extensions");
        this.extensions = urlExtensions != null ? (urlExtensions.equals("*") ? null : StringUtil.splitc((String)urlExtensions, (String)", ")) : new String[]{"html", "htm", "js", "css"};
    }

    public void destroy() {
    }

    protected boolean isGzipEligible(HttpServletRequest request) {
        boolean result;
        block9: {
            String uri;
            block10: {
                block8: {
                    block7: {
                        String forceGzipString;
                        if (this.requestParameterName.length() != 0 && (forceGzipString = request.getParameter(this.requestParameterName)) != null) {
                            return Converter.get().toBooleanValue((Object)forceGzipString, false);
                        }
                        uri = request.getRequestURI();
                        if (uri == null) {
                            return false;
                        }
                        uri = uri.toLowerCase();
                        result = false;
                        if (this.matches != null) break block7;
                        if (this.extensions == null) {
                            return true;
                        }
                        String extension = FileNameUtil.getExtension((String)uri);
                        if (extension.length() <= 0 || StringUtil.equalsOne((String)(extension = extension.toLowerCase()), (String[])this.extensions) == -1) break block8;
                        result = true;
                        break block8;
                    }
                    if (this.wildcards) {
                        result = Wildcard.matchPathOne((String)uri, (String[])this.matches) != -1;
                    } else {
                        for (String match : this.matches) {
                            if (!uri.contains(match)) continue;
                            result = true;
                            break;
                        }
                    }
                }
                if (!result || this.excludes == null) break block9;
                if (!this.wildcards) break block10;
                if (Wildcard.matchPathOne((String)uri, (String[])this.excludes) == -1) break block9;
                result = false;
                break block9;
            }
            for (String exclude : this.excludes) {
                if (!uri.contains(exclude)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

