/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jodd.JoddCore;
import jodd.typeconverter.Convert;

public class CharacterEncodingFilter
implements Filter {
    protected String encoding;
    protected FilterConfig filterConfig;
    protected boolean ignore = true;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String encodingStr;
        if ((this.ignore || request.getCharacterEncoding() == null) && (encodingStr = this.selectEncoding(request)) != null) {
            request.setCharacterEncoding(encodingStr);
            response.setCharacterEncoding(encodingStr);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        if (this.encoding == null) {
            this.encoding = JoddCore.encoding;
        }
        this.ignore = Convert.toBooleanValue((Object)filterConfig.getInitParameter("ignore"), (boolean)true);
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }
}

