/*
 * Decompiled with CFR 0.152.
 */
package jodd.pathref;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import jodd.pathref.Pathref;
import jodd.pathref.PathrefException;
import jodd.util.ClassUtil;

public class PathrefContinue {
    private final Pathref pathref;

    public PathrefContinue(Pathref pathref) {
        this.pathref = pathref;
    }

    public <T> T continueWith(Object currentInstance, String methodName, Class<T> target) {
        Method method;
        Class<?> currentClass = currentInstance.getClass();
        try {
            method = currentClass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new PathrefException("Not a getter: " + methodName, e);
        }
        if (!ClassUtil.isBeanPropertyGetter((Method)method)) {
            throw new PathrefException("Not a getter: " + methodName);
        }
        String getterName = ClassUtil.getBeanPropertyGetterName((Method)method);
        this.pathref.append(getterName);
        if (ClassUtil.isTypeOf(target, List.class)) {
            final Class componentType = ClassUtil.getComponentType((Type)method.getGenericReturnType(), currentClass, (int)0);
            if (componentType == null) {
                throw new PathrefException("Unknown component name for: " + methodName);
            }
            return (T)new ArrayList(){

                @Override
                public Object get(int index) {
                    if (index >= 0) {
                        PathrefContinue.this.pathref.append("[" + index + "]");
                    }
                    return new Pathref(componentType, PathrefContinue.this.pathref).get();
                }
            };
        }
        try {
            return new Pathref<T>(target, this.pathref).get();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

