/*
 * Decompiled with CFR 0.152.
 */
package jodd.methref;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import jodd.methref.InterfaceImplementation;
import jodd.methref.MethrefException;
import jodd.methref.MethrefProxetta;
import jodd.proxetta.ProxettaUtil;
import jodd.util.ClassUtil;
import jodd.util.TypeCache;

public class Methref<C> {
    public static TypeCache<Class> cache = TypeCache.create().threadsafe(true).get();
    private static final MethrefProxetta proxetta = new MethrefProxetta();
    private final C instance;
    private String lastName;
    private boolean injectedMethref = false;

    public Methref(Class<C> target) {
        Object proxy;
        target = ProxettaUtil.resolveTargetClass(target);
        if (target.isInterface()) {
            this.instance = InterfaceImplementation.of(target).createInstanceFor(this);
            return;
        }
        Class proxyClass = (Class)cache.get(target, proxetta::defineProxy);
        try {
            proxy = ClassUtil.newInstance((Class)proxyClass);
            this.injectMethref(proxy);
        }
        catch (Exception ex) {
            throw new MethrefException(ex);
        }
        this.instance = proxy;
    }

    public static <T> Methref<T> of(Class<T> target) {
        return new Methref<T>(target);
    }

    public String name(Consumer<C> consumer) {
        consumer.accept(this.proxy());
        return this.lastName();
    }

    public C proxy() {
        if (!this.injectedMethref) {
            this.injectedMethref = true;
        }
        return this.instance;
    }

    public boolean isMyProxy(Object instance) {
        Methref usedMethref = Methref.readMethref(instance);
        return this == usedMethref;
    }

    public static String lastName(Object instance) {
        Methref m = Methref.readMethref(instance);
        if (m == null) {
            return null;
        }
        return m.lastName;
    }

    public <T> String lastName() {
        return this.lastName;
    }

    public void lastName(String name) {
        this.lastName = name;
    }

    private void injectMethref(C instance) {
        try {
            Field f = instance.getClass().getDeclaredField("$__methref$0");
            f.setAccessible(true);
            f.set(instance, this);
        }
        catch (Exception ex) {
            if (ex instanceof MethrefException) {
                throw (MethrefException)((Object)ex);
            }
            throw new MethrefException("Methref field not found", ex);
        }
    }

    private static Methref readMethref(Object instance) {
        try {
            Field f = instance.getClass().getDeclaredField("$__methref$0");
            f.setAccessible(true);
            return (Methref)f.get(instance);
        }
        catch (Exception ex) {
            if (ex instanceof MethrefException) {
                throw (MethrefException)((Object)ex);
            }
            return null;
        }
    }
}

