/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import jodd.asm7.Label;
import jodd.asm7.MethodVisitor;
import jodd.asm7.Type;
import jodd.proxetta.InvokeAspect;
import jodd.proxetta.InvokeInfo;
import jodd.proxetta.InvokeReplacer;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyTargetReplacement;
import jodd.proxetta.asm.HistoryMethodAdapter;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.asm.WorkData;

public class InvokeReplacerMethodAdapter
extends HistoryMethodAdapter {
    protected final WorkData wd;
    protected final MethodInfo methodInfo;
    protected final InvokeAspect[] aspects;
    protected boolean firstSuperCtorInitCalled;
    protected boolean proxyInfoRequested;
    protected InvokeReplacer newInvokeReplacer;

    public InvokeReplacerMethodAdapter(MethodVisitor mv, MethodInfo methodInfo, WorkData wd, InvokeAspect[] aspects) {
        super(mv);
        this.wd = wd;
        this.aspects = aspects;
        this.methodInfo = methodInfo;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
        InvokeAspect aspect;
        if (this.newInvokeReplacer != null && opcode == 183) {
            String exOwner = owner;
            owner = this.newInvokeReplacer.getOwner();
            name = this.newInvokeReplacer.getMethodName();
            desc = InvokeReplacerMethodAdapter.changeReturnType(desc, 'L' + exOwner + ';');
            super.visitMethodInsn(184, owner, name, desc, isInterface);
            this.newInvokeReplacer = null;
            return;
        }
        InvokeInfo invokeInfo = new InvokeInfo(owner, name, desc);
        if (this.methodInfo.getMethodName().equals("<init>") && !this.firstSuperCtorInitCalled && opcode == 183 && name.equals("<init>") && owner.equals(this.wd.nextSupername)) {
            this.firstSuperCtorInitCalled = true;
            owner = this.wd.superReference;
            super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            return;
        }
        if (opcode == 183 && owner.equals(this.wd.nextSupername) && !name.equals("<init>")) {
            throw new ProxettaException("Super call detected in class " + this.methodInfo.getClassname() + " method: " + this.methodInfo.getSignature() + "\nProxetta can't handle super calls due to VM limitations.");
        }
        InvokeReplacer ir = null;
        InvokeAspect[] invokeAspectArray = this.aspects;
        int n = invokeAspectArray.length;
        for (int i = 0; i < n && (ir = (aspect = invokeAspectArray[i]).pointcut(invokeInfo)) == null; ++i) {
        }
        if (ir == null || ir.isNone()) {
            String[] args;
            if (ProxettaAsmUtil.isCreateArgumentsArrayMethod(name, desc)) {
                ProxyTargetReplacement.createArgumentsArray(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isCreateArgumentsClassArrayMethod(name, desc)) {
                ProxyTargetReplacement.createArgumentsClassArray(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isArgumentsCountMethod(name, desc)) {
                ProxyTargetReplacement.argumentsCount(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isTargetMethodNameMethod(name, desc)) {
                ProxyTargetReplacement.targetMethodName(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isTargetMethodDescriptionMethod(name, desc)) {
                ProxyTargetReplacement.targetMethodDescription(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isTargetMethodSignatureMethod(name, desc)) {
                ProxyTargetReplacement.targetMethodSignature(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isReturnTypeMethod(name, desc)) {
                ProxyTargetReplacement.returnType(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isTargetClassMethod(name, desc)) {
                ProxyTargetReplacement.targetClass(this.mv, this.methodInfo);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isArgumentTypeMethod(name, desc)) {
                int argIndex = this.getArgumentIndex();
                ProxyTargetReplacement.argumentType(this.mv, this.methodInfo, argIndex);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isArgumentMethod(name, desc)) {
                int argIndex = this.getArgumentIndex();
                ProxyTargetReplacement.argument(this.mv, this.methodInfo, argIndex);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isInfoMethod(name, desc)) {
                this.proxyInfoRequested = true;
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isTargetMethodAnnotationMethod(name, desc)) {
                args = this.getLastTwoStringArguments();
                this.mv.visitInsn(87);
                this.mv.visitInsn(87);
                ProxyTargetReplacement.targetMethodAnnotation(this.mv, this.methodInfo, args);
                this.wd.proxyApplied = true;
                return;
            }
            if (ProxettaAsmUtil.isTargetClassAnnotationMethod(name, desc)) {
                args = this.getLastTwoStringArguments();
                this.mv.visitInsn(87);
                this.mv.visitInsn(87);
                ProxyTargetReplacement.targetClassAnnotation(this.mv, this.methodInfo.getClassInfo(), args);
                this.wd.proxyApplied = true;
                return;
            }
            super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            return;
        }
        this.wd.proxyApplied = true;
        String exOwner = owner;
        owner = ir.getOwner();
        name = ir.getMethodName();
        switch (opcode) {
            case 185: {
                desc = InvokeReplacerMethodAdapter.prependArgument(desc, "Ljava/lang/Object;");
                break;
            }
            case 182: {
                desc = InvokeReplacerMethodAdapter.prependArgument(desc, "Ljava/lang/Object;");
                break;
            }
            case 184: {
                break;
            }
            default: {
                throw new ProxettaException("Unsupported opcode: " + opcode);
            }
        }
        if (ir.isPassOwnerName()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/String;");
            super.visitLdcInsn(exOwner);
        }
        if (ir.isPassMethodName()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/String;");
            super.visitLdcInsn(this.methodInfo.getMethodName());
        }
        if (ir.isPassMethodSignature()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/String;");
            super.visitLdcInsn(this.methodInfo.getSignature());
        }
        if (ir.isPassTargetClass()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/Class;");
            this.mv.visitLdcInsn(Type.getType('L' + this.wd.superReference + ';'));
        }
        if (ir.isPassThis()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/Object;");
            this.mv.visitVarInsn(25, 0);
        }
        super.visitMethodInsn(184, owner, name, desc, false);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (owner.equals(this.wd.superReference)) {
            owner = this.wd.thisReference;
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187) {
            InvokeInfo invokeInfo = new InvokeInfo(type, "<init>", "");
            for (InvokeAspect aspect : this.aspects) {
                InvokeReplacer ir = aspect.pointcut(invokeInfo);
                if (ir == null || ir.isNone()) continue;
                this.newInvokeReplacer = ir;
                return;
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (this.proxyInfoRequested) {
            this.proxyInfoRequested = false;
            if (opcode == 58) {
                ProxyTargetReplacement.info(this.mv, this.methodInfo, var);
            }
        }
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.newInvokeReplacer != null && opcode == 89) {
            return;
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    protected static String appendArgument(String desc, String type) {
        int ndx = desc.indexOf(41);
        return desc.substring(0, ndx) + type + desc.substring(ndx);
    }

    protected static String prependArgument(String desc, String type) {
        int ndx = desc.indexOf(40);
        return desc.substring(0, ++ndx) + type + desc.substring(ndx);
    }

    protected static String changeReturnType(String desc, String type) {
        int ndx = desc.indexOf(41);
        return desc.substring(0, ndx + 1) + type;
    }
}

