/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jodd.asm7.ClassReader;
import jodd.asm7.ClassWriter;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.proxetta.Proxetta;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.proxetta.asm.WorkData;
import jodd.util.ClassLoaderUtil;
import jodd.util.ClassUtil;
import jodd.util.DefineClass;
import jodd.util.StringUtil;

public abstract class ProxettaFactory<T extends ProxettaFactory, P extends Proxetta> {
    Logger log = LoggerFactory.getLogger(ProxettaFactory.class);
    protected final P proxetta;
    private InputStream targetInputStream;
    private Class targetClass;
    private String targetClassName;
    protected String requestedProxyClassName;
    protected static int suffixCounter;
    protected ClassWriter destClassWriter;
    protected boolean proxyApplied;
    protected String proxyClassName;

    protected ProxettaFactory(P proxetta) {
        this.proxetta = proxetta;
    }

    protected T _this() {
        return (T)this;
    }

    public T setTargetProxyClassName(String targetProxyClassName) {
        this.requestedProxyClassName = targetProxyClassName;
        return this._this();
    }

    protected T setTarget(InputStream target) {
        this.assertTargetIsNotDefined();
        this.targetInputStream = target;
        this.targetClass = null;
        this.targetClassName = null;
        return this._this();
    }

    protected T setTarget(String targetName) {
        this.assertTargetIsNotDefined();
        try {
            this.targetInputStream = ClassLoaderUtil.getClassAsStream((String)targetName);
            if (this.targetInputStream == null) {
                throw new ProxettaException("Target class not found: " + targetName);
            }
            this.targetClassName = targetName;
            this.targetClass = null;
        }
        catch (IOException ioex) {
            StreamUtil.close((Closeable)this.targetInputStream);
            throw new ProxettaException("Unable to get stream class name: " + targetName, ioex);
        }
        return this._this();
    }

    public T setTarget(Class target) {
        this.assertTargetIsNotDefined();
        try {
            this.targetInputStream = ClassLoaderUtil.getClassAsStream((Class)target);
            if (this.targetInputStream == null) {
                throw new ProxettaException("Target class not found: " + target.getName());
            }
            this.targetClass = target;
            this.targetClassName = target.getName();
        }
        catch (IOException ioex) {
            StreamUtil.close((Closeable)this.targetInputStream);
            throw new ProxettaException("Unable to stream class: " + target.getName(), ioex);
        }
        return this._this();
    }

    private void assertTargetIsNotDefined() {
        if (this.targetInputStream != null) {
            throw new ProxettaException("Target already defined");
        }
    }

    protected String resolveClassNameSuffix() {
        String classNameSuffix = ((Proxetta)this.proxetta).getClassNameSuffix();
        if (classNameSuffix == null) {
            return null;
        }
        if (!((Proxetta)this.proxetta).isVariableClassName()) {
            return classNameSuffix;
        }
        return classNameSuffix + ++suffixCounter;
    }

    protected abstract WorkData process(ClassReader var1, TargetClassInfoReader var2);

    protected void process() {
        ClassReader classReader;
        if (this.targetInputStream == null) {
            throw new ProxettaException("Target missing: " + this.targetClassName);
        }
        try {
            classReader = new ClassReader(this.targetInputStream);
        }
        catch (IOException ioex) {
            throw new ProxettaException("Error reading class input stream", ioex);
        }
        TargetClassInfoReader targetClassInfoReader = new TargetClassInfoReader(((Proxetta)this.proxetta).getClassLoader());
        classReader.accept(targetClassInfoReader, 0);
        this.destClassWriter = new ClassWriter(3);
        if (this.log.isDebugEnabled()) {
            this.log.debug("processing: " + classReader.getClassName());
        }
        WorkData wd = this.process(classReader, targetClassInfoReader);
        this.proxyApplied = wd.proxyApplied;
        this.proxyClassName = wd.thisReference.replace('/', '.');
    }

    public byte[] create() {
        this.process();
        byte[] result = this.toByteArray();
        this.dumpClassInDebugFolder(result);
        if (!((Proxetta)this.proxetta).isForced() && !this.isProxyApplied()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Proxy not applied: " + StringUtil.toSafeString((Object)this.targetClassName));
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Proxy created " + StringUtil.toSafeString((Object)this.targetClassName));
        }
        return result;
    }

    public Class define() {
        this.process();
        if (!((Proxetta)this.proxetta).isForced() && !this.isProxyApplied()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Proxy not applied: " + StringUtil.toSafeString((Object)this.targetClassName));
            }
            if (this.targetClass != null) {
                return this.targetClass;
            }
            if (this.targetClassName != null) {
                try {
                    return ClassLoaderUtil.loadClass((String)this.targetClassName);
                }
                catch (ClassNotFoundException cnfex) {
                    throw new ProxettaException(cnfex);
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Proxy created: " + StringUtil.toSafeString((Object)this.targetClassName));
        }
        try {
            ClassLoader classLoader = ((Proxetta)this.proxetta).getClassLoader();
            if (classLoader == null && (classLoader = ClassLoaderUtil.getDefaultClassLoader()) == null && this.targetClass != null) {
                classLoader = this.targetClass.getClassLoader();
            }
            byte[] bytes = this.toByteArray();
            this.dumpClassInDebugFolder(bytes);
            return DefineClass.of((String)this.getProxyClassName(), (byte[])bytes, (ClassLoader)classLoader);
        }
        catch (Exception ex) {
            throw new ProxettaException("Class definition failed", ex);
        }
    }

    public Object newInstance() {
        Class type = this.define();
        try {
            return ClassUtil.newInstance((Class)type);
        }
        catch (Exception ex) {
            throw new ProxettaException("Invalid Proxetta class", ex);
        }
    }

    protected void dumpClassInDebugFolder(byte[] bytes) {
        String fileName;
        File debugFolder = ((Proxetta)this.proxetta).getDebugFolder();
        if (debugFolder == null) {
            return;
        }
        if (!debugFolder.exists() || !debugFolder.isDirectory()) {
            this.log.warn("Invalid debug folder: " + debugFolder);
        }
        if ((fileName = this.proxyClassName) == null) {
            fileName = "proxetta-" + System.currentTimeMillis();
        }
        fileName = fileName + ".class";
        File file = new File(debugFolder, fileName);
        try {
            FileUtil.writeBytes((File)file, (byte[])bytes);
        }
        catch (IOException ioex) {
            this.log.warn("Error writing class as " + file, (Throwable)ioex);
        }
    }

    protected void assertProxyIsCreated() {
        if (this.destClassWriter == null) {
            throw new ProxettaException("Target not accepted yet!");
        }
    }

    protected byte[] toByteArray() {
        this.assertProxyIsCreated();
        return this.destClassWriter.toByteArray();
    }

    public boolean isProxyApplied() {
        this.assertProxyIsCreated();
        return this.proxyApplied;
    }

    public String getProxyClassName() {
        this.assertProxyIsCreated();
        return this.proxyClassName;
    }
}

