/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import jodd.asm.EmptyClassVisitor;
import jodd.asm.EmptyMethodVisitor;
import jodd.asm.MethodAdapter;
import jodd.asm6.ClassReader;
import jodd.asm6.FieldVisitor;
import jodd.asm6.Label;
import jodd.asm6.MethodVisitor;
import jodd.cache.TypeCache;
import jodd.io.StreamUtil;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxettaNames;
import jodd.proxetta.ProxyAdvice;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.ProxyPointcut;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.asm.WorkData;
import jodd.util.ClassLoaderUtil;

final class ProxyAspectData {
    final ClassReader adviceClassReader;
    final ProxyAspect aspect;
    final Class<? extends ProxyAdvice> advice;
    final ProxyPointcut pointcut;
    final int aspectIndex;
    final WorkData wd;
    String adviceReference;
    boolean ready;
    int maxLocalVarOffset;
    private static TypeCache<ClassReader> adviceClassReaderCache;

    ProxyAspectData(WorkData wd, ProxyAspect aspect, int aspectIndex) {
        this.aspect = aspect;
        this.advice = aspect.advice();
        this.pointcut = aspect.pointcut();
        this.aspectIndex = aspectIndex;
        this.wd = wd;
        this.adviceClassReader = this.getCachedAdviceClassReader(this.advice);
        this.readAdviceData();
    }

    boolean apply(MethodInfo msign) {
        return this.pointcut.apply(msign);
    }

    private ClassReader createAdviceClassReader(Class<? extends ProxyAdvice> advice) {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtil.getClassAsStream(advice);
            ClassReader classReader = new ClassReader(inputStream);
            return classReader;
        }
        catch (IOException ioex) {
            throw new ProxettaException(ioex);
        }
        finally {
            StreamUtil.close((Closeable)inputStream);
        }
    }

    private ClassReader getCachedAdviceClassReader(Class<? extends ProxyAdvice> advice) {
        ClassReader adviceReader;
        if (adviceClassReaderCache == null) {
            adviceClassReaderCache = TypeCache.createDefault();
        }
        if ((adviceReader = (ClassReader)adviceClassReaderCache.get(advice)) == null) {
            adviceReader = this.createAdviceClassReader(advice);
            adviceClassReaderCache.put(advice, (Object)adviceReader);
        }
        return adviceReader;
    }

    ClassReader getAdviceClassReader() {
        return this.adviceClassReader;
    }

    private void readAdviceData() {
        if (this.ready) {
            return;
        }
        this.adviceClassReader.accept(new EmptyClassVisitor(){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ProxyAspectData.this.adviceReference = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (outerName.equals(ProxyAspectData.this.adviceReference)) {
                    throw new ProxettaException("Proxetta doesn't allow inner classes in/for advice: " + ProxyAspectData.this.advice.getName());
                }
                super.visitInnerClass(name, outerName, innerName, access);
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                ProxyAspectData.this.wd.dest.visitField(access, ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex), desc, signature, value);
                return super.visitField(access, name, desc, signature, value);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("<clinit>")) {
                    if (!desc.equals("()V")) {
                        throw new ProxettaException("Invalid static initialization block description for advice: " + ProxyAspectData.this.advice.getName());
                    }
                    name = ProxettaNames.clinitMethodName + ProxettaNames.methodDivider + ProxyAspectData.this.aspectIndex;
                    ProxyAspectData.this.wd.addAdviceClinitMethod(name);
                    return new MethodAdapter(ProxyAspectData.this.wd.dest.visitMethod(access |= 0x12, name, desc, signature, exceptions)){

                        @Override
                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        }

                        @Override
                        public void visitLineNumber(int line, Label start) {
                        }

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                            if (opcode == 184 && owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                        }

                        @Override
                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
                if (name.equals("<init>")) {
                    if (!desc.equals("()V")) {
                        throw new ProxettaException("Advices can have only default constructors. Invalid advice: " + ProxyAspectData.this.advice.getName());
                    }
                    name = ProxettaNames.initMethodName + ProxettaNames.methodDivider + ProxyAspectData.this.aspectIndex;
                    access = ProxettaAsmUtil.makePrivateFinalAccess(access);
                    ProxyAspectData.this.wd.addAdviceInitMethod(name);
                    return new MethodAdapter(ProxyAspectData.this.wd.dest.visitMethod(access, name, desc, signature, exceptions)){
                        int state;

                        @Override
                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        }

                        @Override
                        public void visitLineNumber(int line, Label start) {
                        }

                        @Override
                        public void visitVarInsn(int opcode, int var) {
                            if (this.state == 0 && opcode == 25 && var == 0) {
                                ++this.state;
                                return;
                            }
                            super.visitVarInsn(opcode, var);
                        }

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                            if (this.state == 1 && opcode == 183) {
                                ++this.state;
                                return;
                            }
                            if (opcode == 182 || opcode == 185) {
                                if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                    owner = ProxyAspectData.this.wd.thisReference;
                                    name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                                }
                            } else if (opcode == 184 && owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                        }

                        @Override
                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
                if (!name.equals(ProxettaNames.executeMethodName)) {
                    name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                    return new MethodAdapter(ProxyAspectData.this.wd.dest.visitMethod(access, name, desc, signature, exceptions)){

                        @Override
                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        }

                        @Override
                        public void visitLineNumber(int line, Label start) {
                        }

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                            if (opcode == 182 || opcode == 185) {
                                if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                    owner = ProxyAspectData.this.wd.thisReference;
                                    name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                                }
                            } else if ((opcode == 184 || opcode == 183) && owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceMethodName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                        }

                        @Override
                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (owner.equals(ProxyAspectData.this.adviceReference)) {
                                owner = ProxyAspectData.this.wd.thisReference;
                                name = ProxettaAsmUtil.adviceFieldName(name, ProxyAspectData.this.aspectIndex);
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
                return new EmptyMethodVisitor(){

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (ProxettaAsmUtil.isStoreOpcode(opcode) && var > ProxyAspectData.this.maxLocalVarOffset) {
                            ProxyAspectData.this.maxLocalVarOffset = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }
                };
            }
        }, 0);
        this.maxLocalVarOffset += 2;
        this.ready = true;
    }
}

