/*
 * Decompiled with CFR 0.152.
 */
package jodd.methref;

import java.lang.reflect.Field;
import jodd.cache.TypeCache;
import jodd.methref.MethrefException;
import jodd.methref.MethrefProxetta;
import jodd.proxetta.ProxettaUtil;
import jodd.util.ClassUtil;

public class Methref<C> {
    public static TypeCache<Class> cache = TypeCache.createDefault();
    private static final MethrefProxetta proxetta = new MethrefProxetta();
    private final C instance;

    public Methref(Class<C> target) {
        Object proxy;
        target = ProxettaUtil.resolveTargetClass(target);
        Class proxyClass = (Class)cache.get(target);
        if (proxyClass == null) {
            proxyClass = proxetta.defineProxy(target);
            cache.put(target, (Object)proxyClass);
        }
        try {
            proxy = ClassUtil.newInstance((Class)proxyClass);
        }
        catch (Exception ex) {
            throw new MethrefException(ex);
        }
        this.instance = proxy;
    }

    public static <T> Methref<T> on(Class<T> target) {
        return new Methref<T>(target);
    }

    public static <T> T onto(Class<T> target) {
        return new Methref<T>(target).to();
    }

    public C to() {
        return this.instance;
    }

    public String ref(int dummy) {
        return this.ref(null);
    }

    public String ref(short dummy) {
        return this.ref(null);
    }

    public String ref(byte dummy) {
        return this.ref(null);
    }

    public String ref(char dummy) {
        return this.ref(null);
    }

    public String ref(long dummy) {
        return this.ref(null);
    }

    public String ref(float dummy) {
        return this.ref(null);
    }

    public String ref(double dummy) {
        return this.ref(null);
    }

    public String ref(boolean dummy) {
        return this.ref(null);
    }

    public String ref(Object dummy) {
        if (dummy != null) {
            if (dummy instanceof String) {
                return (String)dummy;
            }
            throw new MethrefException("Target method not collected");
        }
        return this.ref();
    }

    public String ref() {
        if (this.instance == null) {
            return null;
        }
        try {
            Field f = this.instance.getClass().getDeclaredField("$__methodName$0");
            f.setAccessible(true);
            Object name = f.get(this.instance);
            if (name == null) {
                throw new MethrefException("Target method not collected");
            }
            return name.toString();
        }
        catch (Exception ex) {
            if (ex instanceof MethrefException) {
                throw (MethrefException)((Object)ex);
            }
            throw new MethrefException("Methref field not found", ex);
        }
    }
}

