/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.asm.EmptyClassVisitor;
import jodd.asm.EmptyMethodVisitor;
import jodd.asm5.AnnotationVisitor;
import jodd.asm5.ClassReader;
import jodd.asm5.MethodVisitor;
import jodd.asm5.signature.SignatureReader;
import jodd.io.StreamUtil;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.asm.AnnotationReader;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.util.ClassLoaderUtil;

public class TargetClassInfoReader
extends EmptyClassVisitor
implements ClassInfo {
    protected final Map<String, MethodSignatureVisitor> methodSignatures = new HashMap<String, MethodSignatureVisitor>();
    protected final List<ClassReader> superClassReaders = new ArrayList<ClassReader>();
    protected final Set<String> allMethodSignatures = new HashSet<String>();
    protected final ClassLoader classLoader;
    protected String targetPackage;
    protected String targetClassname;
    protected String superName;
    protected String thisReference;
    protected String nextSupername;
    protected String[] superClasses;
    protected AnnotationInfo[] annotations;
    protected List<AnnotationInfo> classAnnotations;
    protected boolean isTargetIntreface;
    protected Set<String> nextInterfaces;

    public TargetClassInfoReader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public MethodSignatureVisitor lookupMethodSignatureVisitor(int access, String name, String desc, String className) {
        String key = ProxettaAsmUtil.createMethodSignaturesKey(access, name, desc, className);
        return this.methodSignatures.get(key);
    }

    public boolean isMarkedForProxy(MethodSignatureVisitor msgin) {
        return this.allMethodSignatures.contains(msgin.getSignature());
    }

    @Override
    public String getPackage() {
        return this.targetPackage;
    }

    @Override
    public String getClassname() {
        return this.targetClassname;
    }

    @Override
    public String getSuperName() {
        return this.superName;
    }

    @Override
    public String getReference() {
        return this.thisReference;
    }

    public String[] getSuperClasses() {
        return this.superClasses;
    }

    @Override
    public AnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int lastSlash = name.lastIndexOf(47);
        this.thisReference = name;
        this.superName = superName;
        this.nextSupername = superName;
        this.targetPackage = lastSlash == -1 ? "" : name.substring(0, lastSlash).replace('/', '.');
        this.targetClassname = name.substring(lastSlash + 1);
        boolean bl = this.isTargetIntreface = (access & 0x200) != 0;
        if (this.isTargetIntreface) {
            this.nextInterfaces = new HashSet<String>();
            if (interfaces != null) {
                for (String inter : interfaces) {
                    this.nextInterfaces.add(inter);
                }
            }
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationReader ar = new AnnotationReader(desc, visible);
        if (this.classAnnotations == null) {
            this.classAnnotations = new ArrayList<AnnotationInfo>();
        }
        this.classAnnotations.add(ar);
        return ar;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x10) != 0) {
            return null;
        }
        MethodSignatureVisitor msign = this.createMethodSignature(access, name, desc, signature, this.thisReference);
        String key = ProxettaAsmUtil.createMethodSignaturesKey(access, name, desc, this.thisReference);
        this.methodSignatures.put(key, msign);
        this.allMethodSignatures.add(msign.getSignature());
        return new MethodAnnotationReader(msign);
    }

    @Override
    public void visitEnd() {
        if (this.classAnnotations != null) {
            this.annotations = this.classAnnotations.toArray(new AnnotationInfo[this.classAnnotations.size()]);
            this.classAnnotations = null;
        }
        ArrayList<String> superList = new ArrayList<String>();
        HashSet<String> allInterfaces = new HashSet<String>();
        if (this.nextInterfaces != null) {
            allInterfaces.addAll(this.nextInterfaces);
        }
        while (this.nextSupername != null) {
            InputStream inputStream = null;
            ClassReader cr = null;
            try {
                inputStream = ClassLoaderUtil.getClassAsStream((String)this.nextSupername, (ClassLoader)this.classLoader);
                cr = new ClassReader(inputStream);
            }
            catch (IOException ioex) {
                try {
                    throw new ProxettaException("Unable to inspect super class: " + this.nextSupername, ioex);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(inputStream);
                    throw throwable;
                }
            }
            StreamUtil.close((Closeable)inputStream);
            superList.add(this.nextSupername);
            this.superClassReaders.add(cr);
            cr.accept(new SuperClassVisitor(), 0);
            if (cr.getInterfaces() == null) continue;
            Collections.addAll(allInterfaces, cr.getInterfaces());
        }
        this.superClasses = superList.toArray(new String[superList.size()]);
        for (String next : allInterfaces) {
            InputStream inputStream = null;
            ClassReader cr = null;
            try {
                inputStream = ClassLoaderUtil.getClassAsStream((String)next, (ClassLoader)this.classLoader);
                cr = new ClassReader(inputStream);
            }
            catch (IOException ioex) {
                try {
                    throw new ProxettaException("Unable to inspect super interface: " + next, ioex);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(inputStream);
                    throw throwable;
                }
            }
            StreamUtil.close((Closeable)inputStream);
            this.superClassReaders.add(cr);
            cr.accept(new SuperClassVisitor(), 0);
        }
    }

    protected MethodSignatureVisitor createMethodSignature(int access, String methodName, String description, String signature, String classname) {
        MethodSignatureVisitor v = new MethodSignatureVisitor(methodName, access, classname, description, signature, this);
        new SignatureReader(signature != null ? signature : description).accept(v);
        return v;
    }

    public String toString() {
        return "target: " + this.targetPackage + '.' + this.targetClassname;
    }

    private class SuperClassVisitor
    extends EmptyClassVisitor {
        String declaredClassName;

        private SuperClassVisitor() {
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            TargetClassInfoReader.this.nextSupername = superName;
            this.declaredClassName = name;
            if (TargetClassInfoReader.this.nextInterfaces != null && interfaces != null) {
                Collections.addAll(TargetClassInfoReader.this.nextInterfaces, interfaces);
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("<init>") || name.equals("<clinit>")) {
                return null;
            }
            MethodSignatureVisitor msign = TargetClassInfoReader.this.createMethodSignature(access, name, desc, signature, TargetClassInfoReader.this.thisReference);
            int acc = msign.getAccessFlags();
            if ((acc & 1) == 0) {
                return null;
            }
            if ((access & 0x10) != 0) {
                return null;
            }
            if (TargetClassInfoReader.this.allMethodSignatures.contains(msign.getSignature())) {
                return null;
            }
            msign.setDeclaredClassName(this.declaredClassName);
            String key = ProxettaAsmUtil.createMethodSignaturesKey(access, name, desc, this.declaredClassName);
            TargetClassInfoReader.this.methodSignatures.put(key, msign);
            TargetClassInfoReader.this.allMethodSignatures.add(msign.getSignature());
            return new MethodAnnotationReader(msign);
        }
    }

    static class MethodAnnotationReader
    extends EmptyMethodVisitor {
        final List<AnnotationInfo> methodAnns = new ArrayList<AnnotationInfo>();
        final List<AnnotationInfo>[] methodParamsAnns;
        final MethodSignatureVisitor msign;

        MethodAnnotationReader(MethodSignatureVisitor msign) {
            this.msign = msign;
            this.methodParamsAnns = new ArrayList[msign.getAllArgumentsSize()];
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationReader ar = new AnnotationReader(desc, visible);
            this.methodAnns.add(ar);
            return ar;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            AnnotationReader ar = new AnnotationReader(desc, visible);
            if (this.methodParamsAnns[parameter] == null) {
                this.methodParamsAnns[parameter] = new ArrayList<AnnotationInfo>();
            }
            this.methodParamsAnns[parameter].add(ar);
            return ar;
        }

        @Override
        public void visitEnd() {
            if (!this.methodAnns.isEmpty()) {
                this.msign.annotations = this.methodAnns.toArray(new AnnotationInfo[this.methodAnns.size()]);
            }
            this.msign.argumentsAnnotation = new AnnotationInfo[this.methodParamsAnns.length][];
            for (int i = 0; i < this.methodParamsAnns.length; ++i) {
                List<AnnotationInfo> methodParamsAnn = this.methodParamsAnns[i];
                if (methodParamsAnn == null) continue;
                this.msign.argumentsAnnotation[i] = methodParamsAnn.toArray(new AnnotationInfo[methodParamsAnn.size()]);
            }
        }
    }
}

