/*
 * Decompiled with CFR 0.152.
 */
package jodd.pathref;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jodd.pathref.PathrefException;
import jodd.pathref.PathrefProxetta;
import jodd.proxetta.ProxettaUtil;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class Pathref<C> {
    public static final int ALL = -1;
    private static final PathrefProxetta proxetta = new PathrefProxetta();
    private static final Map<Class, Class> cache = new WeakHashMap<Class, Class>();
    private final C instance;
    protected String path;

    public Pathref(Class<C> target) {
        C proxy = this.createProxyObject(target);
        this.instance = proxy;
        this.injectPathRef(this, this.instance);
        this.path = "";
    }

    private Pathref(Class<C> target, Pathref root) {
        C proxy = this.createProxyObject(target);
        this.instance = proxy;
        this.injectPathRef(root, this.instance);
        this.path = null;
    }

    protected C createProxyObject(Class<C> target) {
        Object proxy;
        Class proxyClass = cache.get(target = ProxettaUtil.getTargetClass(target));
        if (proxyClass == null) {
            proxyClass = proxetta.defineProxy(target);
            cache.put(target, proxyClass);
        }
        try {
            proxy = proxyClass.newInstance();
        }
        catch (Exception ex) {
            throw new PathrefException(ex);
        }
        return (C)proxy;
    }

    protected void append(String methodName) {
        if (this.path.length() != 0) {
            this.path = this.path + ".";
        }
        if (methodName.startsWith("[")) {
            this.path = StringUtil.substring((String)this.path, (int)0, (int)-1);
        }
        this.path = this.path + methodName;
    }

    public static <T> Pathref<T> on(Class<T> target) {
        return new Pathref<T>(target);
    }

    public <T> T continueWith(Object currentInstance, String methodName, Class<T> target) {
        Method method;
        Class<?> currentClass = currentInstance.getClass();
        try {
            method = currentClass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new PathrefException("Not a getter: " + methodName, e);
        }
        if (!ClassUtil.isBeanPropertyGetter((Method)method)) {
            throw new PathrefException("Not a getter: " + methodName);
        }
        String getterName = ClassUtil.getBeanPropertyGetterName((Method)method);
        this.append(getterName);
        if (ClassUtil.isTypeOf(target, List.class)) {
            final Class componentType = ClassUtil.getComponentType((Type)method.getGenericReturnType(), currentClass, (int)0);
            if (componentType == null) {
                throw new PathrefException("Unknown component name for: " + methodName);
            }
            return (T)new ArrayList(){

                @Override
                public Object get(int index) {
                    if (index >= 0) {
                        Pathref.this.append("[" + index + "]");
                    }
                    return new Pathref(componentType, Pathref.this).to();
                }
            };
        }
        try {
            return new Pathref<T>(target, this).to();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public C to() {
        this.path = "";
        return this.instance;
    }

    public String path(int dummy) {
        return this.path(null);
    }

    public String path(short dummy) {
        return this.path(null);
    }

    public String path(byte dummy) {
        return this.path(null);
    }

    public String path(char dummy) {
        return this.path(null);
    }

    public String path(long dummy) {
        return this.path(null);
    }

    public String path(float dummy) {
        return this.path(null);
    }

    public String path(double dummy) {
        return this.path(null);
    }

    public String path(boolean dummy) {
        return this.path(null);
    }

    public String path(Object object) {
        return this.path;
    }

    public String path() {
        return this.path;
    }

    protected void injectPathRef(Pathref pathref, Object instance) {
        try {
            Field f = instance.getClass().getDeclaredField("$__pathref$0");
            f.setAccessible(true);
            f.set(instance, pathref);
        }
        catch (Exception ex) {
            throw new PathrefException("Pathref field not found", ex);
        }
    }
}

