/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.pointcuts;

import java.lang.annotation.Annotation;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxyPointcut;
import jodd.util.Wildcard;

public abstract class ProxyPointcutSupport
implements ProxyPointcut {
    public boolean isPublic(MethodInfo methodInfo) {
        return (methodInfo.getAccessFlags() & 1) != 0;
    }

    public AnnotationInfo getAnnotation(MethodInfo methodInfo, Class<? extends Annotation> mi) {
        AnnotationInfo[] anns = methodInfo.getAnnotations();
        if (anns == null) {
            return null;
        }
        String anName = mi.getName();
        for (AnnotationInfo ann : anns) {
            if (!ann.getAnnotationClassname().equals(anName)) continue;
            return ann;
        }
        return null;
    }

    public boolean hasAnnotation(MethodInfo methodInfo, Class<? extends Annotation> ... an) {
        AnnotationInfo[] anns = methodInfo.getAnnotations();
        if (anns == null) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : an) {
            String anName = annotationClass.getName();
            for (AnnotationInfo ann : anns) {
                if (!ann.getAnnotationClassname().equals(anName)) continue;
                return true;
            }
        }
        return false;
    }

    public AnnotationInfo getAnnotation(ClassInfo classInfo, Class<? extends Annotation> an) {
        AnnotationInfo[] anns = classInfo.getAnnotations();
        if (anns == null) {
            return null;
        }
        String anName = an.getName();
        for (AnnotationInfo ann : anns) {
            if (!ann.getAnnotationClassname().equals(anName)) continue;
            return ann;
        }
        return null;
    }

    public boolean hasAnnotation(ClassInfo classInfo, Class<? extends Annotation> ... an) {
        AnnotationInfo[] anns = classInfo.getAnnotations();
        if (anns == null) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : an) {
            String anName = annotationClass.getName();
            for (AnnotationInfo ann : anns) {
                if (!ann.getAnnotationClassname().equals(anName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNoArguments(MethodInfo methodInfo) {
        return methodInfo.getArgumentsCount() == 0;
    }

    public boolean hasOneArgument(MethodInfo methodInfo) {
        return methodInfo.getArgumentsCount() == 1;
    }

    public boolean isTopLevelMethod(MethodInfo methodInfo) {
        return methodInfo.isTopLevelMethod();
    }

    public boolean isRootMethod(MethodInfo methodInfo) {
        return "java/lang/Object".equals(methodInfo.getDeclaredClassName());
    }

    public boolean isSpecialMethod(MethodInfo methodInfo) {
        return methodInfo.getMethodName().equals("<init>") || methodInfo.getMethodName().equals("<clinit>");
    }

    public boolean matchMethodName(MethodInfo methodInfo, String wildcard) {
        return Wildcard.match((String)methodInfo.getMethodName(), (String)wildcard);
    }

    public boolean matchClassName(MethodInfo methodInfo, String wildcard) {
        return Wildcard.match((String)methodInfo.getClassname(), (String)wildcard);
    }

    public boolean hasNoReturnValue(MethodInfo methodInfo) {
        return methodInfo.getReturnOpcodeType() == 'V';
    }

    public boolean hasReturnValue(MethodInfo methodInfo) {
        return methodInfo.getReturnOpcodeType() != 'V';
    }

    public boolean and(MethodInfo methodInfo, ProxyPointcut p1, ProxyPointcut p2) {
        return p1.apply(methodInfo) && p2.apply(methodInfo);
    }

    public boolean or(MethodInfo methodInfo, ProxyPointcut p1, ProxyPointcut p2) {
        return p1.apply(methodInfo) || p2.apply(methodInfo);
    }
}

