/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import jodd.asm5.MethodVisitor;
import jodd.asm5.Type;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.util.ClassLoaderUtil;

public class ProxyTargetReplacement {
    public static final String PROXY_TARGET_INFO = "jodd/proxetta/ProxyTargetInfo";

    public static void argumentsCount(MethodVisitor mv, MethodInfo methodInfo) {
        int argsCount = methodInfo.getArgumentsCount();
        ProxettaAsmUtil.pushInt(mv, argsCount);
    }

    public static void argumentType(MethodVisitor mv, MethodInfo methodInfo, int argIndex) {
        ProxettaAsmUtil.checkArgumentIndex(methodInfo, argIndex);
        mv.visitInsn(87);
        ProxettaAsmUtil.loadMethodArgumentClass(mv, methodInfo, argIndex);
    }

    public static void argument(MethodVisitor mv, MethodInfo methodInfo, int argIndex) {
        ProxettaAsmUtil.checkArgumentIndex(methodInfo, argIndex);
        mv.visitInsn(87);
        ProxettaAsmUtil.loadMethodArgumentAsObject(mv, methodInfo, argIndex);
    }

    public static void createArgumentsArray(MethodVisitor mv, MethodInfo methodInfo) {
        int argsCount = methodInfo.getArgumentsCount();
        ProxettaAsmUtil.pushInt(mv, argsCount);
        mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < argsCount; ++i) {
            mv.visitInsn(89);
            ProxettaAsmUtil.pushInt(mv, i);
            ProxettaAsmUtil.loadMethodArgumentAsObject(mv, methodInfo, i + 1);
            mv.visitInsn(83);
        }
    }

    public static void createArgumentsClassArray(MethodVisitor mv, MethodInfo methodInfo) {
        int argsCount = methodInfo.getArgumentsCount();
        ProxettaAsmUtil.pushInt(mv, argsCount);
        mv.visitTypeInsn(189, "java/lang/Class");
        for (int i = 0; i < argsCount; ++i) {
            mv.visitInsn(89);
            ProxettaAsmUtil.pushInt(mv, i);
            ProxettaAsmUtil.loadMethodArgumentClass(mv, methodInfo, i + 1);
            mv.visitInsn(83);
        }
    }

    public static void returnType(MethodVisitor mv, MethodInfo methodInfo) {
        ProxettaAsmUtil.loadClass(mv, methodInfo.getReturnOpcodeType(), methodInfo.getReturnTypeName());
    }

    public static void targetMethodName(MethodVisitor mv, MethodInfo methodInfo) {
        mv.visitLdcInsn(methodInfo.getMethodName());
    }

    public static void targetMethodSignature(MethodVisitor mv, MethodInfo methodInfo) {
        mv.visitLdcInsn(methodInfo.getSignature());
    }

    public static void targetMethodDescription(MethodVisitor mv, MethodInfo methodInfo) {
        mv.visitLdcInsn(methodInfo.getDescription());
    }

    public static void targetClass(MethodVisitor mv, MethodInfo methodInfo) {
        ClassInfo classInfo = methodInfo.getClassInfo();
        mv.visitLdcInsn(Type.getType('L' + classInfo.getReference() + ';'));
    }

    public static void info(MethodVisitor mv, MethodInfo methodInfo) {
        mv.visitTypeInsn(187, PROXY_TARGET_INFO);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, PROXY_TARGET_INFO, "<init>", "()V", false);
        int argsOff = methodInfo.getAllArgumentsSize();
        mv.visitVarInsn(58, ++argsOff);
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.argumentsCount(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "argumentCount", "I");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.createArgumentsClassArray(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "argumentsClasses", "[Ljava/lang/Class;");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.createArgumentsArray(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "arguments", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.returnType(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "returnType", "Ljava/lang/Class;");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.targetMethodName(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "targetMethodName", "Ljava/lang/String;");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.targetMethodDescription(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "targetMethodDescription", "Ljava/lang/String;");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.targetMethodSignature(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "targetMethodSignature", "Ljava/lang/String;");
        mv.visitVarInsn(25, argsOff);
        ProxyTargetReplacement.targetClass(mv, methodInfo);
        mv.visitFieldInsn(181, PROXY_TARGET_INFO, "targetClass", "Ljava/lang/Class;");
        mv.visitVarInsn(25, argsOff);
    }

    public static void targetMethodAnnotation(MethodVisitor mv, MethodInfo methodInfo, String[] args) {
        AnnotationInfo[] anns = methodInfo.getAnnotations();
        if (anns != null) {
            ProxyTargetReplacement.targetAnnotation(mv, anns, args);
        }
    }

    public static void targetClassAnnotation(MethodVisitor mv, ClassInfo classInfo, String[] args) {
        AnnotationInfo[] anns = classInfo.getAnnotations();
        if (anns != null) {
            ProxyTargetReplacement.targetAnnotation(mv, anns, args);
        } else {
            mv.visitInsn(1);
        }
    }

    private static void targetAnnotation(MethodVisitor mv, AnnotationInfo[] anns, String[] args) {
        for (AnnotationInfo ann : anns) {
            Class<?> elementValueClass;
            String annotationSignature = ann.getAnnotationSignature();
            Method annotationMethod = null;
            if (!annotationSignature.equals(args[0])) continue;
            String elementName = args[1];
            Object elementValue = ann.getElement(elementName);
            if (elementValue == null) {
                String annotationClass = ann.getAnnotationClassname();
                try {
                    Class annotation = ClassLoaderUtil.loadClass((String)annotationClass);
                    annotationMethod = annotation.getMethod(elementName, new Class[0]);
                    elementValue = annotationMethod.getDefaultValue();
                }
                catch (Exception ignore) {
                    elementValue = null;
                }
                if (elementValue == null) {
                    mv.visitInsn(1);
                    return;
                }
            }
            if (!(elementValueClass = elementValue.getClass()).isArray()) {
                ProxettaAsmUtil.visitElementValue(mv, elementValue, true);
                return;
            }
            Class<?> componentType = elementValueClass.getComponentType();
            String annotationClass = ann.getAnnotationClassname();
            try {
                if (annotationMethod == null) {
                    Class annotation = ClassLoaderUtil.loadClass((String)annotationClass);
                    annotationMethod = annotation.getMethod(elementName, new Class[0]);
                }
                componentType = annotationMethod.getReturnType().getComponentType();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            int size = Array.getLength(elementValue);
            ProxettaAsmUtil.pushInt(mv, size);
            ProxettaAsmUtil.newArray(mv, componentType);
            for (int i = 0; i < size; ++i) {
                mv.visitInsn(89);
                ProxettaAsmUtil.pushInt(mv, i);
                Object value = Array.get(elementValue, i);
                ProxettaAsmUtil.visitElementValue(mv, value, false);
                ProxettaAsmUtil.storeIntoArray(mv, componentType);
            }
            return;
        }
    }
}

