/*
 * Decompiled with CFR 0.152.
 */
package jodd.paramo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jodd.asm5.ClassReader;
import jodd.paramo.MethodFinder;
import jodd.paramo.MethodParameter;
import jodd.paramo.ParamoException;
import jodd.util.ClassLoaderUtil;

public class Paramo {
    protected static final String CTOR_METHOD = "<init>";

    public static MethodParameter[] resolveParameters(AccessibleObject methodOrCtor) {
        InputStream stream;
        Class<Object> declaringClass;
        String name;
        Class[] paramTypes;
        if (methodOrCtor instanceof Method) {
            Method method = (Method)methodOrCtor;
            paramTypes = method.getParameterTypes();
            name = method.getName();
            declaringClass = method.getDeclaringClass();
        } else {
            Constructor constructor = (Constructor)methodOrCtor;
            paramTypes = constructor.getParameterTypes();
            declaringClass = constructor.getDeclaringClass();
            name = CTOR_METHOD;
        }
        if (paramTypes.length == 0) {
            return MethodParameter.EMPTY_ARRAY;
        }
        try {
            stream = ClassLoaderUtil.getClassAsStream(declaringClass);
        }
        catch (IOException ioex) {
            throw new ParamoException("Failed to read class bytes: " + declaringClass.getName(), ioex);
        }
        if (stream == null) {
            throw new ParamoException("Class not found: " + declaringClass);
        }
        try {
            ClassReader reader = new ClassReader(stream);
            MethodFinder visitor = new MethodFinder(declaringClass, name, paramTypes);
            reader.accept(visitor, 0);
            return visitor.getResolvedParameters();
        }
        catch (IOException ioex) {
            throw new ParamoException(ioex);
        }
    }
}

