/*
 * Decompiled with CFR 0.152.
 */
package jodd.json.meta;

import java.util.List;
import jodd.util.ArraysUtil;
import jodd.util.InExRules;

public class TypeData {
    public final InExRules<String, String> rules;
    public final boolean strict;
    public final String[] jsonNames;
    public final String[] realNames;

    public TypeData(List<String> includes, List<String> excludes, boolean strict, String[] jsonNames, String[] realNames) {
        this.rules = new InExRules(strict ? InExRules.InExType.WHITELIST : InExRules.InExType.BLACKLIST, InExRules.WILDCARD_STRING_MATCHER);
        for (String include : includes) {
            this.rules.include((Object)include);
        }
        for (String exclude : excludes) {
            this.rules.exclude((Object)exclude);
        }
        this.strict = strict;
        this.jsonNames = jsonNames;
        this.realNames = realNames;
    }

    public String resolveRealName(String jsonName) {
        if (this.jsonNames == null) {
            return jsonName;
        }
        int jsonIndex = ArraysUtil.indexOf((Object[])this.jsonNames, (Object)jsonName);
        if (jsonIndex == -1) {
            return jsonName;
        }
        return this.realNames[jsonIndex];
    }

    public String resolveJsonName(String realName) {
        if (this.realNames == null) {
            return realName;
        }
        int realIndex = ArraysUtil.indexOf((Object[])this.realNames, (Object)realName);
        if (realIndex == -1) {
            return realName;
        }
        return this.jsonNames[realIndex];
    }
}

