/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;
import jodd.json.CharArrayInput;
import jodd.json.CharSequenceInput;
import jodd.json.CharsInput;
import jodd.json.JsonArray;
import jodd.json.JsonException;
import jodd.json.JsonObject;
import jodd.json.JsonParserBase;
import jodd.json.MapToBean;
import jodd.json.ObjectParser;
import jodd.json.Path;
import jodd.json.ValueConverter;
import jodd.json.meta.JsonAnnotationManager;
import jodd.json.meta.TypeData;
import jodd.util.CharUtil;

public class JsonParser
extends JsonParserBase {
    private static final char[] T_RUE = new char[]{'r', 'u', 'e'};
    private static final char[] F_ALSE = new char[]{'a', 'l', 's', 'e'};
    private static final char[] N_ULL = new char[]{'u', 'l', 'l'};
    public static final String KEYS = "keys";
    public static final String VALUES = "values";
    protected CharsInput input;
    protected int total;
    protected Path path;
    protected boolean useAltPaths = Defaults.useAltPathsByParser;
    protected boolean lazy = Defaults.lazy;
    protected boolean looseMode = Defaults.loose;
    protected Class rootType;
    protected MapToBean mapToBean;
    private boolean notFirstObject;
    private final JsonAnnotationManager jsonAnnotationManager;
    protected Map<Path, Class> mappings;
    protected Map<Path, ValueConverter> convs;
    protected String classMetadataName = Defaults.classMetadataName;
    protected char[] text = new char[512];
    protected int textLen;
    private static final char[] UNQUOTED_DELIMETERS = ",:[]{}\\\"'".toCharArray();
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    public static JsonParser create() {
        return new JsonParser();
    }

    public static JsonParser createLazyOne() {
        return new JsonParser().lazy(true);
    }

    public JsonParser() {
        super(Defaults.strictTypes);
        this.jsonAnnotationManager = JsonAnnotationManager.get();
    }

    protected void reset() {
        this.input.ndx = 0;
        this.textLen = 0;
        this.path = new Path();
        this.notFirstObject = false;
        if (this.useAltPaths) {
            this.path.altPath = new Path();
        }
        if (this.classMetadataName != null) {
            this.mapToBean = this.createMapToBean(this.classMetadataName);
        }
    }

    public JsonParser useAltPaths() {
        this.useAltPaths = true;
        return this;
    }

    public JsonParser looseMode(boolean looseMode) {
        this.looseMode = looseMode;
        return this;
    }

    public JsonParser strictTypes(boolean strictTypes) {
        this.strictTypes = strictTypes;
        return this;
    }

    public JsonParser lazy(boolean lazy) {
        this.lazy = lazy;
        this.mapSupplier = lazy ? LAZYMAP_SUPPLIER : HASHMAP_SUPPLIER;
        this.listSupplier = lazy ? LAZYLIST_SUPPLIER : ARRAYLIST_SUPPLIER;
        return this;
    }

    public JsonParser map(Class target) {
        this.rootType = target;
        return this;
    }

    public JsonParser map(String path, Class target) {
        if (path == null) {
            this.rootType = target;
            return this;
        }
        if (this.mappings == null) {
            this.mappings = new HashMap<Path, Class>();
        }
        this.mappings.put(Path.parse(path), target);
        return this;
    }

    protected Class replaceWithMappedTypeForPath(Class target) {
        Class newType;
        if (this.mappings == null) {
            return target;
        }
        Path altPath = this.path.getAltPath();
        if (altPath != null && !altPath.equals(this.path) && (newType = this.mappings.get(altPath)) != null) {
            return newType;
        }
        newType = this.mappings.get(this.path);
        if (newType != null) {
            return newType;
        }
        return target;
    }

    public JsonParser withValueConverter(String path, ValueConverter valueConverter) {
        if (this.convs == null) {
            this.convs = new HashMap<Path, ValueConverter>();
        }
        this.convs.put(Path.parse(path), valueConverter);
        return this;
    }

    protected ValueConverter lookupValueConverter() {
        if (this.convs == null) {
            return null;
        }
        return this.convs.get(this.path);
    }

    public JsonParser setClassMetadataName(String name) {
        this.classMetadataName = name;
        return this;
    }

    public JsonParser withClassMetadata(boolean useMetadata) {
        this.classMetadataName = useMetadata ? "__class" : null;
        return this;
    }

    public JsonParser allowClass(String classPattern) {
        if (this.classnameWhitelist == null) {
            this.classnameWhitelist = new ArrayList<String>();
        }
        this.classnameWhitelist.add(classPattern);
        return this;
    }

    public JsonParser allowAllClasses() {
        this.classnameWhitelist = null;
        return this;
    }

    public <T> T parse(String input, Class<T> targetType) {
        this.rootType = targetType;
        return this._parse(new CharSequenceInput(input));
    }

    public JsonObject parseAsJsonObject(String input) {
        return new JsonObject((Map)this.parse(input));
    }

    public JsonArray parseAsJsonArray(String input) {
        return new JsonArray((List)this.parse(input));
    }

    public <T> List<T> parseAsList(String string, Class<T> componentType) {
        return (List)new JsonParser().map(VALUES, componentType).parse(string);
    }

    public <K, V> Map<K, V> parseAsMap(String string, Class<K> keyType, Class<V> valueType) {
        return (Map)new JsonParser().map(KEYS, keyType).map(VALUES, valueType).parse(string);
    }

    public <T> T parse(String input) {
        return this._parse(new CharSequenceInput(input));
    }

    public <T> T parse(char[] input, Class<T> targetType) {
        this.rootType = targetType;
        return this._parse(new CharArrayInput(input));
    }

    public <T> T parse(char[] input) {
        return this._parse(new CharArrayInput(input));
    }

    private <T> T _parse(CharsInput charsInput) {
        Object value;
        this.input = charsInput;
        this.total = this.input.total;
        this.reset();
        this.skipWhiteSpaces();
        try {
            value = this.parseValue(this.rootType, null, null);
        }
        catch (IndexOutOfBoundsException iofbex) {
            this.syntaxError("End of JSON", iofbex);
            return null;
        }
        this.skipWhiteSpaces();
        if (!this.input.isAtTheEnd()) {
            this.syntaxError("Trailing chars", null);
            return null;
        }
        if (this.lazy) {
            value = this.resolveLazyValue(value);
        }
        if (this.classMetadataName != null && this.rootType == null && value instanceof Map) {
            Map map = (Map)value;
            value = this.mapToBean.map2bean(map, null);
        }
        return (T)value;
    }

    protected Object parseValue(Class targetType, Class keyType, Class componentType) {
        char c = this.input.charAtNdx();
        switch (c) {
            case '\'': {
                if (!this.looseMode) break;
            }
            case '\"': {
                ++this.input.ndx;
                Object string = this.parseStringContent(c);
                ValueConverter valueConverter = this.lookupValueConverter();
                if (valueConverter != null) {
                    return valueConverter.convert(string);
                }
                if (targetType != null && targetType != String.class) {
                    string = this.convertType(string, targetType);
                }
                return string;
            }
            case '{': {
                ++this.input.ndx;
                if (this.lazy) {
                    if (this.notFirstObject) {
                        ObjectParser value = new ObjectParser(this, targetType, keyType, componentType);
                        this.skipObject();
                        return value;
                    }
                    this.notFirstObject = true;
                }
                return this.parseObjectContent(targetType, keyType, componentType);
            }
            case '[': {
                ++this.input.ndx;
                return this.parseArrayContent(targetType, componentType);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                Object number = this.parseNumber();
                ValueConverter valueConverter = this.lookupValueConverter();
                if (valueConverter != null) {
                    return valueConverter.convert(number);
                }
                if (targetType != null) {
                    number = this.convertType(number, targetType);
                }
                return number;
            }
            case 'n': {
                ++this.input.ndx;
                if (!this.match(N_ULL)) break;
                ValueConverter valueConverter = this.lookupValueConverter();
                if (valueConverter != null) {
                    return valueConverter.convert(null);
                }
                return null;
            }
            case 't': {
                ++this.input.ndx;
                if (!this.match(T_RUE)) break;
                Object value = Boolean.TRUE;
                ValueConverter valueConverter = this.lookupValueConverter();
                if (valueConverter != null) {
                    return valueConverter.convert(value);
                }
                if (targetType != null) {
                    value = this.convertType(value, targetType);
                }
                return value;
            }
            case 'f': {
                ++this.input.ndx;
                if (!this.match(F_ALSE)) break;
                Object value = Boolean.FALSE;
                ValueConverter valueConverter = this.lookupValueConverter();
                if (valueConverter != null) {
                    return valueConverter.convert(value);
                }
                if (targetType != null) {
                    value = this.convertType(value, targetType);
                }
                return value;
            }
        }
        if (this.looseMode) {
            Object string = this.parseUnquotedStringContent();
            ValueConverter valueConverter = this.lookupValueConverter();
            if (valueConverter != null) {
                return valueConverter.convert(string);
            }
            if (targetType != null && targetType != String.class) {
                string = this.convertType(string, targetType);
            }
            return string;
        }
        this.syntaxError("Invalid char: " + this.input.charAtNdx(), null);
        return null;
    }

    private Object resolveLazyValue(Object value) {
        if (value instanceof Supplier) {
            value = ((Supplier)value).get();
        }
        return value;
    }

    private void skipObject() {
        int bracketCount = 1;
        boolean insideString = false;
        while (!this.input.isEnd()) {
            char c = this.input.charAtNdx();
            if (insideString) {
                if (c == '\"' && this.notPrecededByEvenNumberOfBackslashes()) {
                    insideString = false;
                }
            } else if (c == '\"') {
                insideString = true;
            } else if (c == '{') {
                ++bracketCount;
            } else if (c == '}' && --bracketCount == 0) {
                ++this.input.ndx;
                return;
            }
            ++this.input.ndx;
        }
    }

    private boolean notPrecededByEvenNumberOfBackslashes() {
        int count = 0;
        for (int pos = this.input.ndx; pos > 0 && this.input.charAt(pos - 1) == '\\'; --pos) {
            ++count;
        }
        return count % 2 == 0;
    }

    protected String parseString() {
        char quote = '\"';
        if (this.looseMode) {
            quote = this.consumeOneOf('\"', '\'');
            if (quote == '\u0000') {
                return this.parseUnquotedStringContent();
            }
        } else {
            this.consume(quote);
        }
        return this.parseStringContent(quote);
    }

    protected String parseStringContent(char quote) {
        char c;
        int startNdx = this.input.ndx;
        while (true) {
            if ((c = this.input.charAtNdx()) == quote) {
                ++this.input.ndx;
                return this.input.subString(startNdx, this.input.ndx - 1);
            }
            if (c == '\\') break;
            ++this.input.ndx;
        }
        this.textLen = this.input.ndx - startNdx;
        this.growEmpty();
        int i = startNdx;
        for (int j = 0; j < this.textLen; ++j) {
            this.text[j] = this.input.charAt(i);
            ++i;
        }
        while (true) {
            if ((c = this.input.charAtNdx()) == quote) {
                ++this.input.ndx;
                String str = new String(this.text, 0, this.textLen);
                this.textLen = 0;
                return str;
            }
            if (c == '\\') {
                ++this.input.ndx;
                c = this.input.charAtNdx();
                switch (c) {
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case '/': {
                        c = '/';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'u': {
                        ++this.input.ndx;
                        c = this.parseUnicode();
                        break;
                    }
                    default: {
                        if (this.looseMode) {
                            if (c == 39) break;
                            c = '\\';
                            --this.input.ndx;
                            break;
                        }
                        this.syntaxError("Invalid escape char: " + c, null);
                    }
                }
            }
            this.text[this.textLen] = c;
            ++this.textLen;
            this.growAndCopy();
            ++this.input.ndx;
        }
    }

    protected void growEmpty() {
        if (this.textLen >= this.text.length) {
            int newSize = this.textLen << 1;
            this.text = new char[newSize];
        }
    }

    protected void growAndCopy() {
        if (this.textLen == this.text.length) {
            int newSize = this.text.length << 1;
            char[] newText = new char[newSize];
            if (this.textLen > 0) {
                System.arraycopy(this.text, 0, newText, 0, this.textLen);
            }
            this.text = newText;
        }
    }

    protected char parseUnicode() {
        int i0 = CharUtil.hex2int((char)this.input.charAtNdx());
        ++this.input.ndx;
        int i1 = CharUtil.hex2int((char)this.input.charAtNdx());
        ++this.input.ndx;
        int i2 = CharUtil.hex2int((char)this.input.charAtNdx());
        ++this.input.ndx;
        int i3 = CharUtil.hex2int((char)this.input.charAtNdx());
        return (char)((i0 << 12) + (i1 << 8) + (i2 << 4) + i3);
    }

    protected String parseUnquotedStringContent() {
        int startNdx = this.input.ndx;
        while (true) {
            char c;
            if ((c = this.input.charAtNdx()) <= ' ' || CharUtil.equalsOne((char)c, (char[])UNQUOTED_DELIMETERS)) {
                int currentNdx = this.input.ndx;
                this.skipWhiteSpaces();
                return this.input.subString(startNdx, currentNdx);
            }
            ++this.input.ndx;
        }
    }

    protected Number parseNumber() {
        long longNumber;
        int startIndex = this.input.ndx++;
        char c = this.input.charAtNdx();
        boolean isDouble = false;
        boolean isExp = false;
        if (c == '-') {
            // empty if block
        }
        while (!this.input.isEnd()) {
            c = this.input.charAtNdx();
            if (c >= '0' && c <= '9') {
                ++this.input.ndx;
                continue;
            }
            if (c <= ' ' || c == ',' || c == '}' || c == ']') break;
            if (c == '.') {
                isDouble = true;
            } else if (c == 'e' || c == 'E') {
                isExp = true;
            }
            ++this.input.ndx;
        }
        String value = this.input.subString(startIndex, this.input.ndx);
        if (isDouble) {
            return Double.valueOf(value);
        }
        if (isExp) {
            longNumber = Double.valueOf(value).longValue();
        } else if (value.length() >= 19) {
            BigInteger bigInteger = new BigInteger(value);
            if (JsonParser.isGreaterThanLong(bigInteger)) {
                return bigInteger;
            }
            longNumber = bigInteger.longValue();
        } else {
            longNumber = Long.parseLong(value);
        }
        if (longNumber >= Integer.MIN_VALUE && longNumber <= Integer.MAX_VALUE) {
            return (int)longNumber;
        }
        return longNumber;
    }

    private static boolean isGreaterThanLong(BigInteger bigInteger) {
        return bigInteger.compareTo(MAX_LONG) > 0 || bigInteger.compareTo(MIN_LONG) < 0;
    }

    protected Object parseArrayContent(Class targetType, Class componentType) {
        if (targetType == Object.class) {
            targetType = List.class;
        }
        targetType = this.replaceWithMappedTypeForPath(targetType);
        if (componentType == null && targetType != null && targetType.isArray()) {
            componentType = targetType.getComponentType();
        }
        this.path.push(VALUES);
        componentType = this.replaceWithMappedTypeForPath(componentType);
        Collection<Object> target = this.newArrayInstance(targetType);
        boolean koma = false;
        block4: while (true) {
            this.skipWhiteSpaces();
            char c = this.input.charAtNdx();
            if (c == ']') {
                if (koma) {
                    this.syntaxError("Trailing comma", null);
                }
                ++this.input.ndx;
                this.path.pop();
                return target;
            }
            Object value = this.parseValue(componentType, null, null);
            target.add(value);
            this.skipWhiteSpaces();
            c = this.input.charAtNdx();
            switch (c) {
                case ']': {
                    ++this.input.ndx;
                    break block4;
                }
                case ',': {
                    ++this.input.ndx;
                    koma = true;
                    continue block4;
                }
                default: {
                    this.syntaxError("Invalid char: expected ] or ,", null);
                    continue block4;
                }
            }
            break;
        }
        this.path.pop();
        if (targetType != null) {
            return this.convertType(target, targetType);
        }
        return target;
    }

    protected Object parseObjectContent(Class targetType, Class valueKeyType, Class valueType) {
        Object target;
        if (targetType == Object.class) {
            targetType = Map.class;
        }
        targetType = this.replaceWithMappedTypeForPath(targetType);
        boolean isTargetTypeMap = true;
        boolean isTargetRealTypeMap = true;
        ClassDescriptor targetTypeClassDescriptor = null;
        TypeData typeData = null;
        if (targetType != null) {
            targetTypeClassDescriptor = ClassIntrospector.get().lookup(targetType);
            isTargetRealTypeMap = targetTypeClassDescriptor.isMap();
            typeData = this.jsonAnnotationManager.lookupTypeData(targetType);
        }
        if (isTargetRealTypeMap) {
            this.path.push(KEYS);
            valueKeyType = this.replaceWithMappedTypeForPath(valueKeyType);
            this.path.pop();
        }
        if (this.classMetadataName == null) {
            target = this.newObjectInstance(targetType);
            isTargetTypeMap = isTargetRealTypeMap;
        } else {
            target = this.mapSupplier.get();
        }
        boolean koma = false;
        block4: while (true) {
            Object value;
            String key;
            this.skipWhiteSpaces();
            char c = this.input.charAtNdx();
            if (c == '}') {
                if (koma) {
                    this.syntaxError("Trailing comma", null);
                }
                ++this.input.ndx;
                break;
            }
            koma = false;
            String keyOriginal = key = this.parseString();
            this.skipWhiteSpaces();
            this.consume(':');
            this.skipWhiteSpaces();
            PropertyDescriptor pd = null;
            Class propertyType = null;
            Class keyType = null;
            Class componentType = null;
            if (!isTargetRealTypeMap) {
                key = this.jsonAnnotationManager.resolveRealName(targetType, key);
            }
            if (!isTargetTypeMap && (pd = targetTypeClassDescriptor.getPropertyDescriptor(key, true)) != null) {
                propertyType = pd.getType();
                keyType = pd.resolveKeyType(true);
                componentType = pd.resolveComponentType(true);
            }
            if (!isTargetTypeMap) {
                this.path.push(key);
                value = this.parseValue(propertyType, keyType, componentType);
                this.path.pop();
                if (typeData.rules.match((Object)keyOriginal) && pd != null) {
                    if (this.lazy) {
                        value = this.resolveLazyValue(value);
                    }
                    this.injectValueIntoObject(target, pd, value);
                }
            } else {
                Object keyValue = key;
                if (valueKeyType != null) {
                    keyValue = this.convertType(key, valueKeyType);
                }
                if (isTargetRealTypeMap) {
                    this.path.push(VALUES, key);
                    valueType = this.replaceWithMappedTypeForPath(valueType);
                } else {
                    this.path.push(key);
                }
                value = this.parseValue(valueType, null, null);
                this.path.pop();
                ((Map)target).put(keyValue, value);
            }
            this.skipWhiteSpaces();
            c = this.input.charAtNdx();
            switch (c) {
                case '}': {
                    ++this.input.ndx;
                    break block4;
                }
                case ',': {
                    ++this.input.ndx;
                    koma = true;
                    continue block4;
                }
                default: {
                    this.syntaxError("Invalid char: expected } or ,", null);
                    continue block4;
                }
            }
            break;
        }
        if (this.classMetadataName != null) {
            target = this.mapToBean.map2bean((Map)target, targetType);
        }
        return target;
    }

    protected void consume(char c) {
        if (this.input.charAtNdx() != c) {
            this.syntaxError("Invalid char: expected " + c, null);
        }
        ++this.input.ndx;
    }

    protected char consumeOneOf(char c1, char c2) {
        char c = this.input.charAtNdx();
        if (c != c1 && c != c2) {
            return '\u0000';
        }
        ++this.input.ndx;
        return c;
    }

    protected final void skipWhiteSpaces() {
        while (!this.input.isEnd()) {
            if (this.input.charAtNdx() > ' ') {
                return;
            }
            ++this.input.ndx;
        }
        return;
    }

    protected final boolean match(char[] target) {
        for (char c : target) {
            if (this.input.charAtNdx() != c) {
                return false;
            }
            ++this.input.ndx;
        }
        return true;
    }

    protected void syntaxError(String message, Throwable cause) {
        int to;
        String left = "...";
        String right = "...";
        int offset = 10;
        int from = this.input.ndx - 10;
        if (from < 0) {
            from = 0;
            left = "";
        }
        if ((to = this.input.ndx + 10) > this.input.total) {
            to = this.input.total;
            right = "";
        }
        CharSequence str = this.input.subSequence(from, to);
        throw new JsonException("Syntax error! " + message + "\noffset: " + this.input.ndx + " near: \"" + left + str + right + "\"", cause);
    }

    public static class Defaults {
        public static final String DEFAULT_CLASS_METADATA_NAME = "__class";
        public static boolean lazy = false;
        public static boolean useAltPathsByParser = false;
        public static boolean loose = false;
        public static String classMetadataName = null;
        public static boolean strictTypes = true;
    }
}

