/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import jodd.cache.TypeCache;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.json.JsonArray;
import jodd.json.JsonObject;
import jodd.json.TypeJsonSerializer;
import jodd.json.impl.ArraysJsonSerializer;
import jodd.json.impl.BooleanArrayJsonSerializer;
import jodd.json.impl.BooleanJsonSerializer;
import jodd.json.impl.ByteArrayJsonSerializer;
import jodd.json.impl.CalendarJsonSerializer;
import jodd.json.impl.CharSequenceJsonSerializer;
import jodd.json.impl.CharacterJsonSerializer;
import jodd.json.impl.ClassJsonSerializer;
import jodd.json.impl.DateJsonSerializer;
import jodd.json.impl.DoubleArrayJsonSerializer;
import jodd.json.impl.DoubleJsonSerializer;
import jodd.json.impl.EnumJsonSerializer;
import jodd.json.impl.FileJsonSerializer;
import jodd.json.impl.FloatArrayJsonSerializer;
import jodd.json.impl.FloatJsonSerializer;
import jodd.json.impl.IntArrayJsonSerializer;
import jodd.json.impl.IterableJsonSerializer;
import jodd.json.impl.JsonArraySerializer;
import jodd.json.impl.JsonObjectSerializer;
import jodd.json.impl.JulianDateSerializer;
import jodd.json.impl.LocalDateSerializer;
import jodd.json.impl.LocalDateTimeSerializer;
import jodd.json.impl.LocalTimeSerializer;
import jodd.json.impl.LongArrayJsonSerializer;
import jodd.json.impl.MapJsonSerializer;
import jodd.json.impl.NumberJsonSerializer;
import jodd.json.impl.ObjectJsonSerializer;
import jodd.json.impl.UUIDJsonSerializer;
import jodd.time.JulianDate;

public class TypeJsonSerializerMap {
    private static final TypeJsonSerializerMap TYPE_JSON_SERIALIZER_MAP = new TypeJsonSerializerMap();
    private final TypeJsonSerializerMap defaultSerializerMap;
    protected final TypeCache<TypeJsonSerializer> map = TypeCache.createDefault();
    protected final TypeCache<TypeJsonSerializer> cache = TypeCache.createDefault();

    public static TypeJsonSerializerMap get() {
        return TYPE_JSON_SERIALIZER_MAP;
    }

    public TypeJsonSerializerMap() {
        this.registerDefaults();
        this.defaultSerializerMap = null;
    }

    public TypeJsonSerializerMap(TypeJsonSerializerMap defaultSerializerMap) {
        this.defaultSerializerMap = defaultSerializerMap;
    }

    public void registerDefaults() {
        this.map.put(Object.class, (Object)new ObjectJsonSerializer());
        this.map.put(Map.class, (Object)new MapJsonSerializer());
        this.map.put(Iterable.class, (Object)new IterableJsonSerializer());
        this.map.put(JsonObject.class, (Object)new JsonObjectSerializer());
        this.map.put(JsonArray.class, (Object)new JsonArraySerializer());
        this.map.put(int[].class, (Object)new IntArrayJsonSerializer());
        this.map.put(long[].class, (Object)new LongArrayJsonSerializer());
        this.map.put(double[].class, (Object)new DoubleArrayJsonSerializer());
        this.map.put(float[].class, (Object)new FloatArrayJsonSerializer());
        this.map.put(boolean[].class, (Object)new BooleanArrayJsonSerializer());
        this.map.put(byte[].class, (Object)new ByteArrayJsonSerializer());
        this.map.put(Integer[].class, (Object)new ArraysJsonSerializer<Integer>(){

            protected int getLength(Integer[] array) {
                return array.length;
            }

            protected Integer get(Integer[] array, int index) {
                return array[index];
            }
        });
        this.map.put(Long[].class, (Object)new ArraysJsonSerializer<Long>(){

            protected int getLength(Long[] array) {
                return array.length;
            }

            protected Long get(Long[] array, int index) {
                return array[index];
            }
        });
        this.map.put(Arrays.class, new ArraysJsonSerializer());
        TypeJsonSerializer<CharSequence> jsonSerializer = new CharSequenceJsonSerializer();
        this.map.put(String.class, (Object)jsonSerializer);
        this.map.put(StringBuilder.class, (Object)jsonSerializer);
        this.map.put(CharSequence.class, (Object)jsonSerializer);
        jsonSerializer = new NumberJsonSerializer();
        this.map.put(Number.class, (Object)jsonSerializer);
        this.map.put(Integer.class, (Object)jsonSerializer);
        this.map.put(Integer.TYPE, (Object)jsonSerializer);
        this.map.put(Long.class, (Object)jsonSerializer);
        this.map.put(Long.TYPE, (Object)jsonSerializer);
        DoubleJsonSerializer doubleJsonSerializer = new DoubleJsonSerializer();
        this.map.put(Double.class, (Object)doubleJsonSerializer);
        this.map.put(Double.TYPE, (Object)doubleJsonSerializer);
        FloatJsonSerializer floatJsonSerializer = new FloatJsonSerializer();
        this.map.put(Float.class, (Object)floatJsonSerializer);
        this.map.put(Float.TYPE, (Object)floatJsonSerializer);
        this.map.put(BigInteger.class, (Object)jsonSerializer);
        this.map.put(BigDecimal.class, (Object)jsonSerializer);
        this.map.put(Boolean.class, (Object)new BooleanJsonSerializer());
        this.map.put(Boolean.TYPE, (Object)new BooleanJsonSerializer());
        this.map.put(Date.class, (Object)new DateJsonSerializer());
        this.map.put(Calendar.class, (Object)new CalendarJsonSerializer());
        this.map.put(JulianDate.class, (Object)new JulianDateSerializer());
        this.map.put(LocalDateTime.class, (Object)new LocalDateTimeSerializer());
        this.map.put(LocalDate.class, (Object)new LocalDateSerializer());
        this.map.put(LocalTime.class, (Object)new LocalTimeSerializer());
        this.map.put(Enum.class, (Object)new EnumJsonSerializer());
        this.map.put(File.class, (Object)new FileJsonSerializer(FileJsonSerializer.Type.PATH));
        jsonSerializer = new CharacterJsonSerializer();
        this.map.put(Character.class, (Object)jsonSerializer);
        this.map.put(Character.TYPE, (Object)jsonSerializer);
        this.map.put(UUID.class, (Object)new UUIDJsonSerializer());
        this.map.put(Class.class, (Object)new ClassJsonSerializer());
        this.cache.clear();
    }

    public void register(Class type, TypeJsonSerializer typeJsonSerializer) {
        this.map.put(type, (Object)typeJsonSerializer);
        this.cache.clear();
    }

    public TypeJsonSerializer lookup(Class type) {
        return (TypeJsonSerializer)this.cache.get(type, () -> this._lookup(type));
    }

    protected TypeJsonSerializer lookupSerializer(Class type) {
        TypeJsonSerializer tjs = (TypeJsonSerializer)this.map.get(type);
        if (tjs == null && this.defaultSerializerMap != null) {
            tjs = (TypeJsonSerializer)this.defaultSerializerMap.map.get(type);
        }
        return tjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeJsonSerializer _lookup(Class type) {
        TypeCache<TypeJsonSerializer> typeCache = this.map;
        synchronized (typeCache) {
            Class[] superclasses;
            Class[] interfaces;
            TypeJsonSerializer tjs = this.lookupSerializer(type);
            if (tjs != null) {
                return tjs;
            }
            ClassDescriptor cd = ClassIntrospector.get().lookup(type);
            if (cd.isArray()) {
                return this.lookupSerializer(Arrays.class);
            }
            for (Class interfaze : interfaces = cd.getAllInterfaces()) {
                tjs = this.lookupSerializer(interfaze);
                if (tjs == null) continue;
                return tjs;
            }
            for (Class clazz : superclasses = cd.getAllSuperclasses()) {
                tjs = this.lookupSerializer(clazz);
                if (tjs == null) continue;
                return tjs;
            }
            return this.lookupSerializer(Object.class);
        }
    }
}

