/*
 * Decompiled with CFR 0.152.
 */
package jodd.json.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.json.JoddJson;
import jodd.json.meta.JSONAnnotation;
import jodd.json.meta.JSONAnnotationData;
import jodd.util.AnnotationDataReader;
import jodd.util.ArraysUtil;
import jodd.util.InExRules;

public class JsonAnnotationManager {
    private final Map<Class, TypeData> typeDataMap = new HashMap<Class, TypeData>();

    public void reset() {
        this.typeDataMap.clear();
    }

    public TypeData lookupTypeData(Class type) {
        TypeData typeData = this.typeDataMap.get(type);
        if (typeData == null) {
            if (JoddJson.serializationSubclassAware) {
                typeData = this.findSubclassTypeData(type);
            }
            if (typeData == null) {
                typeData = this.scanClassForAnnotations(type);
                this.typeDataMap.put(type, typeData);
            }
        }
        return typeData;
    }

    protected TypeData _lookupTypeData(Class type) {
        TypeData typeData = this.typeDataMap.get(type);
        if (typeData == null) {
            typeData = this.scanClassForAnnotations(type);
            this.typeDataMap.put(type, typeData);
        }
        return typeData;
    }

    protected TypeData findSubclassTypeData(Class type) {
        Class[] interfaces;
        Class[] superClasses;
        if (type.getAnnotation(JoddJson.jsonAnnotation) != null) {
            return null;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        for (Class superClass : superClasses = cd.getAllSuperclasses()) {
            if (superClass.getAnnotation(JoddJson.jsonAnnotation) == null) continue;
            return this._lookupTypeData(superClass);
        }
        for (Class interfaze : interfaces = cd.getAllInterfaces()) {
            if (interfaze.getAnnotation(JoddJson.jsonAnnotation) == null) continue;
            return this._lookupTypeData(interfaze);
        }
        return null;
    }

    public String resolveJsonName(Class type, String name) {
        TypeData typeData = this.lookupTypeData(type);
        return typeData.resolveJsonName(name);
    }

    public String resolveRealName(Class type, String jsonName) {
        TypeData typeData = this.lookupTypeData(type);
        return typeData.resolveRealName(jsonName);
    }

    private TypeData scanClassForAnnotations(Class type) {
        JSONAnnotationData data;
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        PropertyDescriptor[] pds = cd.getAllPropertyDescriptors();
        ArrayList<String> includedList = new ArrayList<String>();
        ArrayList<String> excludedList = new ArrayList<String>();
        ArrayList<String> jsonNames = new ArrayList<String>();
        ArrayList<String> realNames = new ArrayList<String>();
        JSONAnnotation<? extends Annotation> jsonAnnotation = new JSONAnnotation<Annotation>(JoddJson.jsonAnnotation);
        for (PropertyDescriptor pd : pds) {
            FieldDescriptor fd;
            Method method;
            AnnotationDataReader.AnnotationData data2 = null;
            MethodDescriptor md = pd.getReadMethodDescriptor();
            if (md != null) {
                method = md.getMethod();
                data2 = jsonAnnotation.readAnnotationData(method);
            }
            if (data2 == null && (md = pd.getWriteMethodDescriptor()) != null) {
                method = md.getMethod();
                data2 = jsonAnnotation.readAnnotationData(method);
            }
            if (data2 == null && (fd = pd.getFieldDescriptor()) != null) {
                Field field = fd.getField();
                data2 = jsonAnnotation.readAnnotationData(field);
            }
            if (data2 == null) continue;
            String propertyName = pd.getName();
            String newPropertyName = data2.getName();
            if (newPropertyName != null) {
                realNames.add(propertyName);
                jsonNames.add(newPropertyName);
                propertyName = newPropertyName;
            }
            if (data2.isIncluded()) {
                includedList.add(propertyName);
                continue;
            }
            excludedList.add(propertyName);
        }
        String[] reals = null;
        if (!realNames.isEmpty()) {
            reals = realNames.toArray(new String[realNames.size()]);
        }
        String[] jsons = null;
        if (!jsonNames.isEmpty()) {
            jsons = jsonNames.toArray(new String[jsonNames.size()]);
        }
        return new TypeData(includedList, excludedList, (data = (JSONAnnotationData)jsonAnnotation.readAnnotationData(type)) != null && data.isStrict(), jsons, reals);
    }

    public static class TypeData {
        public final InExRules<String, String> rules = new InExRules();
        public final boolean strict;
        public final String[] jsonNames;
        public final String[] realNames;

        public TypeData(List<String> includes, List<String> excludes, boolean strict, String[] jsonNames, String[] realNames) {
            for (String include : includes) {
                this.rules.include((Object)include);
            }
            for (String exclude : excludes) {
                this.rules.exclude((Object)exclude);
            }
            this.strict = strict;
            this.jsonNames = jsonNames;
            this.realNames = realNames;
        }

        public String resolveRealName(String jsonName) {
            if (this.jsonNames == null) {
                return jsonName;
            }
            int jsonIndex = ArraysUtil.indexOf((Object[])this.jsonNames, (Object)jsonName);
            if (jsonIndex == -1) {
                return jsonName;
            }
            return this.realNames[jsonIndex];
        }

        public String resolveJsonName(String realName) {
            if (this.realNames == null) {
                return realName;
            }
            int realIndex = ArraysUtil.indexOf((Object[])this.realNames, (Object)realName);
            if (realIndex == -1) {
                return realName;
            }
            return this.jsonNames[realIndex];
        }
    }
}

