/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import javax.servlet.http.HttpServletRequest;
import jodd.joy.auth.UserAuth;
import jodd.joy.auth.UserSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.HttpStatus;
import jodd.madvoc.result.JsonResult;
import jodd.servlet.ServletUtil;

public class AuthInterceptor<T>
implements ActionInterceptor {
    public static UserAuth userAuth;
    protected boolean return404instead401 = true;
    protected boolean authenticateViaBasicAuth = true;

    private UserAuth<T> userAuth() {
        return userAuth;
    }

    public void setReturn404instead401(boolean return404instead401) {
        this.return404instead401 = return404instead401;
    }

    public void setAuthenticateViaBasicAuth(boolean authenticateViaBasicAuth) {
        this.authenticateViaBasicAuth = authenticateViaBasicAuth;
    }

    public Object intercept(ActionRequest actionRequest) throws Exception {
        ActionRuntime actionRuntime = actionRequest.getActionRuntime();
        if (actionRuntime.isAuthenticated()) {
            T grantedAuthToken = this.authenticateUserViaHttpSession(actionRequest);
            if (grantedAuthToken == null) {
                grantedAuthToken = this.authenticateUserViaToken(actionRequest);
            }
            if (this.authenticateViaBasicAuth && grantedAuthToken == null) {
                grantedAuthToken = this.authenticateUserViaBasicAuth(actionRequest);
            }
            if (grantedAuthToken == null) {
                return JsonResult.of((HttpStatus)(this.return404instead401 ? HttpStatus.error404().notFound() : HttpStatus.error401().unauthorized("Not authorized")));
            }
            if (!this.authorized(actionRequest)) {
                return JsonResult.of((HttpStatus)HttpStatus.error403().forbidden());
            }
        }
        return actionRequest.invoke();
    }

    protected T authenticateUserViaHttpSession(ActionRequest actionRequest) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        UserSession userSession = UserSession.get(servletRequest);
        if (userSession == null) {
            return null;
        }
        Object authToken = userSession.getAuthToken();
        if (authToken == null) {
            return null;
        }
        T newAuthToken = this.userAuth().rotateToken(authToken);
        if (newAuthToken != authToken) {
            UserSession<T> newUserSesion = new UserSession<T>(newAuthToken, this.userAuth().tokenValue(newAuthToken));
            newUserSesion.start(servletRequest, actionRequest.getHttpServletResponse());
        }
        return newAuthToken;
    }

    protected T authenticateUserViaToken(ActionRequest actionRequest) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        String token = ServletUtil.resolveAuthBearerToken((HttpServletRequest)servletRequest);
        if (token == null) {
            return null;
        }
        T authToken = this.userAuth().validateToken(token);
        if (authToken == null) {
            return null;
        }
        T newAuthToken = this.userAuth().rotateToken(authToken);
        actionRequest.getHttpServletResponse().setHeader("Authentication", "Bearer: " + this.userAuth().tokenValue(newAuthToken));
        return newAuthToken;
    }

    protected T authenticateUserViaBasicAuth(ActionRequest actionRequest) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        String username = ServletUtil.resolveAuthUsername((HttpServletRequest)servletRequest);
        if (username == null) {
            return null;
        }
        String password = ServletUtil.resolveAuthPassword((HttpServletRequest)servletRequest);
        T authToken = this.userAuth().login(username, password);
        if (authToken == null) {
            return null;
        }
        return authToken;
    }

    protected boolean authorized(ActionRequest actionRequest) {
        return true;
    }
}

