/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jodd.cache.TypeCache;
import jodd.chalk.Chalk256;
import jodd.joy.JoyBase;
import jodd.joy.JoyPetiteConfig;
import jodd.joy.JoyProps;
import jodd.joy.JoyProxetta;
import jodd.joy.JoyScanner;
import jodd.joy.Print;
import jodd.petite.AutomagicPetiteConfigurator;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteContainer;
import jodd.petite.proxetta.ProxettaAwarePetiteContainer;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SessionScope;
import jodd.petite.scope.SingletonScope;
import jodd.util.ClassUtil;
import jodd.util.Consumers;
import jodd.util.StringUtil;

public class JoyPetite
extends JoyBase
implements JoyPetiteConfig {
    protected final Supplier<String> appNameSupplier;
    protected final Supplier<JoyScanner> joyScannerSupplier;
    protected final Supplier<JoyProps> joyPropsSupplier;
    protected final Supplier<JoyProxetta> joyProxettaSupplier;
    protected PetiteContainer petiteContainer;
    protected boolean isWebApplication = true;
    private boolean autoConfiguration = true;
    private boolean externalsCache = true;
    private final Consumers<PetiteContainer> petiteContainerConsumers = Consumers.empty();

    public JoyPetite(Supplier<String> appNameSupplier, Supplier<JoyProxetta> joyProxettaSupplier, Supplier<JoyProps> joyPropsSupplier, Supplier<JoyScanner> joyScannerSupplier) {
        this.appNameSupplier = appNameSupplier;
        this.joyProxettaSupplier = joyProxettaSupplier;
        this.joyScannerSupplier = joyScannerSupplier;
        this.joyPropsSupplier = joyPropsSupplier;
    }

    public PetiteContainer getPetiteContainer() {
        return this.requireStarted(this.petiteContainer);
    }

    @Override
    public JoyPetite disableAutoConfiguration() {
        this.requireNotStarted(this.petiteContainer);
        this.autoConfiguration = false;
        return this;
    }

    @Override
    public JoyPetite disableExternalsCache() {
        this.requireNotStarted(this.petiteContainer);
        this.externalsCache = true;
        return this;
    }

    @Override
    public JoyPetite withPetite(Consumer<PetiteContainer> petiteContainerConsumer) {
        this.requireNotStarted(this.petiteContainer);
        this.petiteContainerConsumers.add(petiteContainerConsumer);
        return this;
    }

    @Override
    public void start() {
        this.initLogger();
        this.log.info("PETITE start  ----------");
        this.petiteContainer = this.createPetiteContainer();
        if (this.externalsCache) {
            this.petiteContainer.setExternalsCache(TypeCache.createDefault());
        }
        this.log.info("Web application? " + this.isWebApplication);
        if (!this.isWebApplication) {
            this.petiteContainer.registerScope(SessionScope.class, (Scope)new SingletonScope(this.petiteContainer));
        }
        this.petiteContainer.defineParameters(this.joyPropsSupplier.get().getProps());
        if (this.autoConfiguration) {
            AutomagicPetiteConfigurator automagicPetiteConfigurator = new AutomagicPetiteConfigurator(this.petiteContainer);
            automagicPetiteConfigurator.registerAsConsumer(this.joyScannerSupplier.get().getClassScanner());
        }
        this.petiteContainerConsumers.accept((Object)this.petiteContainer);
        this.log.info("PETITE OK!");
    }

    protected ProxettaAwarePetiteContainer createPetiteContainer() {
        return new ProxettaAwarePetiteContainer(this.joyProxettaSupplier.get().getProxetta());
    }

    @Override
    public void stop() {
        if (this.log != null) {
            this.log.info("PETITE stop");
        }
        if (this.petiteContainer != null) {
            this.petiteContainer.shutdown();
        }
        this.petiteContainer = null;
    }

    public void printBeans(int width) {
        Print print = new Print();
        print.line("Beans", width);
        ArrayList beanDefinitionList = new ArrayList();
        String appName = this.appNameSupplier.get();
        String prefix = appName + ".";
        this.petiteContainer.forEachBean(beanDefinitionList::add);
        beanDefinitionList.stream().sorted((bd1, bd2) -> {
            if (bd1.name().startsWith(prefix)) {
                if (bd2.name().startsWith(prefix)) {
                    return bd1.name().compareTo(bd2.name());
                }
                return 1;
            }
            if (bd2.name().startsWith(prefix)) {
                if (bd1.name().startsWith(prefix)) {
                    return bd1.name().compareTo(bd2.name());
                }
                return -1;
            }
            return bd1.name().compareTo(bd2.name());
        }).forEach(beanDefinition -> {
            print.out((Chalk256)Chalk256.chalk().yellow(), this.scopeName((BeanDefinition)beanDefinition), 10);
            print.space();
            print.outLeftRightNewLine((Chalk256)Chalk256.chalk().green(), beanDefinition.name(), (Chalk256)Chalk256.chalk().blue(), ClassUtil.getShortClassName((Class)beanDefinition.type(), (int)2), width - 10 - 1);
        });
        print.line(width);
    }

    private String scopeName(BeanDefinition beanDefinition) {
        String scopeName = beanDefinition.scope().getSimpleName();
        scopeName = StringUtil.cutSuffix((String)scopeName, (String)"Scope");
        return scopeName.toLowerCase();
    }
}

