/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jodd.io.findfile.ClassScanner;
import jodd.joy.JoyBase;
import jodd.joy.JoyScannerConfig;
import jodd.typeconverter.Converter;
import jodd.util.ClassPathURLs;

public class JoyScanner
extends JoyBase
implements JoyScannerConfig {
    private final List<String> includedEntries = new ArrayList<String>();
    private final List<String> includedJars = new ArrayList<String>();
    private final List<String> excludedJars = new ArrayList<String>();
    private final List<Class> appClasses = new ArrayList<Class>();
    private boolean ignoreExceptions;
    protected ClassScanner classScanner;

    @Override
    public JoyScanner setIncludedEntries(String ... includedEntries) {
        this.requireNotStarted(this.classScanner);
        Collections.addAll(this.includedEntries, includedEntries);
        return this;
    }

    @Override
    public JoyScanner setIncludedJars(String ... includedJars) {
        this.requireNotStarted(this.classScanner);
        Collections.addAll(this.includedJars, includedJars);
        return this;
    }

    @Override
    public JoyScanner setExcludedJars(String ... excludedJars) {
        this.requireNotStarted(this.classScanner);
        Collections.addAll(this.excludedJars, excludedJars);
        return this;
    }

    @Override
    public JoyScanner setIgnoreExceptions(boolean ignoreExceptions) {
        this.requireNotStarted(this.classScanner);
        this.ignoreExceptions = ignoreExceptions;
        return this;
    }

    @Override
    public JoyScanner scanClasspathOf(Class applicationClass) {
        this.requireNotStarted(this.classScanner);
        this.appClasses.add(applicationClass);
        return this;
    }

    @Override
    public JoyScanner scanClasspathOf(Object applicationObject) {
        this.requireNotStarted(this.classScanner);
        return this.scanClasspathOf(applicationObject.getClass());
    }

    public ClassScanner getClassScanner() {
        return this.requireStarted(this.classScanner);
    }

    @Override
    public void start() {
        this.initLogger();
        this.log.info("SCANNER start ----------");
        this.classScanner = new ClassScanner(){

            protected void scanJarFile(File file) {
                JoyScanner.this.log.debug("Scanning jar: " + file);
                super.scanJarFile(file);
            }

            protected void scanClassPath(File root) {
                JoyScanner.this.log.debug("Scanning path: " + root);
                super.scanClassPath(root);
            }
        };
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scan entries: " + Converter.get().toString(this.includedEntries));
            this.log.debug("Scan jars: " + Converter.get().toString(this.includedJars));
            this.log.debug("Scan exclude jars: " + Converter.get().toString(this.excludedJars));
            this.log.debug("Scan ignore exception: " + this.ignoreExceptions);
        }
        this.classScanner.excludeCommonEntries();
        this.classScanner.excludeCommonJars();
        this.classScanner.excludeJars(this.excludedJars.toArray(new String[0]));
        if (this.includedEntries.isEmpty() && this.includedJars.isEmpty()) {
            this.classScanner.excludeAllEntries(false);
        } else {
            this.classScanner.excludeAllEntries(true);
            this.includedEntries.add("jodd.*");
        }
        this.classScanner.detectEntriesMode(true).includeEntries(this.includedEntries.toArray(new String[0])).includeJars(this.includedJars.toArray(new String[0])).ignoreException(this.ignoreExceptions).scanDefaultClasspath();
        this.appClasses.forEach(clazz -> this.classScanner.scan(ClassPathURLs.of(null, (Class)clazz)));
        this.log.info("SCANNER OK!");
    }

    @Override
    public void stop() {
        this.classScanner = null;
    }
}

