/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import jodd.Jodd;
import jodd.joy.JoyDb;
import jodd.joy.JoyInit;
import jodd.joy.JoyMadvoc;
import jodd.joy.JoyPaths;
import jodd.joy.JoyPetite;
import jodd.joy.JoyProps;
import jodd.joy.JoyProxetta;
import jodd.joy.JoyScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.log.LoggerProvider;
import jodd.log.impl.SimpleLogger;
import jodd.madvoc.WebApp;
import jodd.madvoc.petite.PetiteWebApp;
import jodd.petite.PetiteContainer;

public class JoddJoy {
    public static final String APP_DIR = "app.dir";
    public static final String PETITE_CORE = "core";
    public static final String PETITE_DBPOOL = "dbpool";
    public static final String PETITE_DB = "db";
    public static final String PETITE_SCAN = "scan";
    private static JoddJoy joddJoy;
    private String name = "joy";
    private Supplier<LoggerProvider> loggerProviderSupplier;
    private final JoyPaths joyPaths = new JoyPaths();
    private final JoyProps joyProps = new JoyProps(() -> this.name);
    private final JoyScanner joyScanner = new JoyScanner();
    private final JoyProxetta joyProxetta = new JoyProxetta();
    private final JoyPetite joyPetite = new JoyPetite(this.joyProxetta::getProxetta, this.joyProps::getProps, () -> this.joyScanner);
    private JoyDb joyDb = new JoyDb(this.joyPetite::getPetiteContainer, () -> this.joyScanner);
    private JoyMadvoc joyMadvoc = new JoyMadvoc(this.joyPetite::getPetiteContainer, this.joyProxetta::getProxetta, this.joyProps::getProps, () -> this.joyScanner);
    private Logger log;

    public static synchronized JoddJoy get() {
        if (joddJoy == null) {
            joddJoy = new JoddJoy();
        }
        return joddJoy;
    }

    public JoddJoy() {
        this.joyPaths.start();
    }

    public JoddJoy setAppName(String name) {
        Objects.requireNonNull(name);
        this.name = name;
        return this;
    }

    public JoddJoy withLoggerProvider(Supplier<LoggerProvider> loggerProviderSupplier) {
        this.loggerProviderSupplier = loggerProviderSupplier;
        return this;
    }

    public JoddJoy withProps(Consumer<JoyProps> propsConsumer) {
        propsConsumer.accept(this.joyProps);
        return this;
    }

    public JoddJoy withScanner(Consumer<JoyScanner> scannerConsumer) {
        scannerConsumer.accept(this.joyScanner);
        return this;
    }

    public JoddJoy withProxetta(Consumer<JoyProxetta> proxettaConsumer) {
        proxettaConsumer.accept(this.joyProxetta);
        return this;
    }

    public JoddJoy withPetite(Consumer<JoyPetite> petiteConsumer) {
        petiteConsumer.accept(this.joyPetite);
        return this;
    }

    public JoddJoy withDb(Consumer<JoyDb> dbConsumer) {
        dbConsumer.accept(this.joyDb);
        return this;
    }

    public JoddJoy withWebApp(Consumer<WebApp> webAppConsumer) {
        this.joyMadvoc.add(webAppConsumer);
        return this;
    }

    public JoddJoy useWebApp(Supplier<PetiteWebApp> webAppSupplier) {
        this.joyMadvoc.setWebAppSupplier(webAppSupplier);
        return this;
    }

    public void start(ServletContext servletContext) {
        LoggerProvider loggerProvider = null;
        if (this.loggerProviderSupplier != null) {
            loggerProvider = this.loggerProviderSupplier.get();
        }
        if (loggerProvider == null) {
            loggerProvider = SimpleLogger.PROVIDER;
        }
        LoggerFactory.setLoggerProvider((LoggerProvider)loggerProvider);
        this.log = LoggerFactory.getLogger(JoddJoy.class);
        this.log.info(Jodd.JODD);
        this.log.info("Ah, Joy!");
        this.log.info("Logging using: " + loggerProvider.getClass().getSimpleName());
        try {
            this.joyPaths.start();
            this.joyProps.start();
            this.joyScanner.start();
            this.joyProxetta.start();
            this.joyPetite.start();
            this.joyDb.start();
            this.joyMadvoc.setServletContext(servletContext);
            this.joyMadvoc.start();
            this.runJoyInitBeans();
            this.joyScanner.stop();
            this.joyProps.stop();
        }
        catch (Exception ex) {
            if (this.log != null) {
                this.log.error(ex.toString(), (Throwable)ex);
            } else {
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            this.stop();
            throw ex;
        }
        this.log.info("Joy is up. Enjoy Joy!");
    }

    public void stop() {
        try {
            this.joyDb.stop();
            this.joyPetite.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.log != null) {
            this.log.info("Joy is stopped! Bye, bye!");
        }
    }

    protected void runJoyInitBeans() {
        PetiteContainer pc = this.joyPetite.getPetiteContainer();
        pc.forEachBeanType(JoyInit.class, beanName -> {
            JoyInit joyInit = (JoyInit)pc.getBean(beanName);
            if (joyInit != null) {
                joyInit.onJoy();
            }
        });
    }
}

