/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import jodd.joy.JoyBase;
import jodd.props.Props;
import jodd.props.PropsUtil;

public class JoyProps
extends JoyBase {
    protected final Supplier<String> nameSupplier;
    protected Props props;
    private List<String> propsNamePatterns = new ArrayList<String>();
    private List<String> propsProfiles = new ArrayList<String>();

    public JoyProps(Supplier<String> nameSupplier) {
        this.nameSupplier = nameSupplier;
    }

    public Props getProps() {
        return this.props;
    }

    public JoyProps addPropsFile(String namePattern) {
        this.propsNamePatterns.add(namePattern);
        return this;
    }

    public JoyProps addPropsProfiles(String ... profiles) {
        Collections.addAll(this.propsProfiles, profiles);
        return this;
    }

    @Override
    void start() {
        this.initLogger();
        this.log.info("PROPS start ----------");
        this.props = this.createProps();
        this.props.loadSystemProperties("sys");
        this.props.loadEnvironment("env");
        this.log.info("Loaded sys&env props: " + this.props.countTotalProperties() + " properties.");
        this.props.setActiveProfiles(this.propsProfiles.toArray(new String[this.propsProfiles.size()]));
        String[] patterns = new String[this.propsNamePatterns.size() + 1];
        patterns[0] = "/" + this.nameSupplier.get() + "*.prop*";
        for (int i = 0; i < this.propsNamePatterns.size(); ++i) {
            patterns[i + 1] = this.propsNamePatterns.get(i);
        }
        this.log.debug("Loading props from classpath...");
        PropsUtil.loadFromClasspath((Props)this.props, (String[])patterns);
        this.log.info("Props is ready: " + this.props.countTotalProperties() + " properties.");
    }

    protected Props createProps() {
        Props props = new Props();
        props.setSkipEmptyProps(true);
        props.setIgnoreMissingMacros(true);
        return props;
    }

    @Override
    void stop() {
        this.props = null;
    }
}

