/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.core;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import jodd.db.DbManager;
import jodd.db.DbSessionProvider;
import jodd.db.connection.ConnectionProvider;
import jodd.db.jtx.DbJtxSessionProvider;
import jodd.db.jtx.DbJtxTransactionManager;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.config.AutomagicDbOomConfigurator;
import jodd.db.pool.CoreConnectionPool;
import jodd.io.findfile.ClassFinder;
import jodd.joy.core.AppInit;
import jodd.joy.core.AppScanner;
import jodd.joy.exception.AppException;
import jodd.joy.jtx.meta.ReadWriteTransaction;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.meta.Transaction;
import jodd.jtx.proxy.AnnotationTxAdvice;
import jodd.jtx.proxy.AnnotationTxAdviceManager;
import jodd.jtx.proxy.AnnotationTxAdviceSupport;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.PetiteContainer;
import jodd.petite.config.AutomagicPetiteConfigurator;
import jodd.petite.proxetta.ProxettaAwarePetiteContainer;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SessionScope;
import jodd.petite.scope.SingletonScope;
import jodd.props.Props;
import jodd.props.PropsUtil;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.ProxyPointcut;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.proxetta.pointcuts.MethodAnnotationPointcut;
import jodd.util.ClassLoaderUtil;
import jodd.util.SystemUtil;

public abstract class DefaultAppCore {
    public static final String APP_DIR = "app.dir";
    public static final String APP_WEB = "app.web";
    public static final String PETITE_CORE = "core";
    public static final String PETITE_DBPOOL = "dbpool";
    public static final String PETITE_DB = "db";
    public static final String PETITE_DBOOM = "dboom";
    public static final String PETITE_INIT = "init";
    public static final String PETITE_PROPS = "props";
    public static final String PETITE_SCAN = "scan";
    protected static Logger log;
    protected String appDir;
    protected boolean isWebApplication;
    protected String[] appPropsProfiles;
    protected boolean initialized;
    protected String appPropsName;
    protected String appPropsNamePattern;
    protected Props appProps;
    protected AppScanner appScanner;
    protected ProxyProxetta proxetta;
    protected PetiteContainer petite;
    protected boolean useDatabase = true;
    protected JtxTransactionManager jtxManager;
    protected ConnectionProvider connectionProvider;
    protected Class<? extends Annotation>[] jtxAnnotations;
    protected String jtxScopePattern;
    protected AppInit appInit;

    protected DefaultAppCore() {
    }

    public boolean isWebApplication() {
        return this.isWebApplication;
    }

    public String getAppDir() {
        return this.appDir;
    }

    public void initCore() {
        if (this.appPropsName == null) {
            this.appPropsName = "app.props";
        }
        if (this.appPropsNamePattern == null) {
            int index = this.appPropsName.lastIndexOf(46);
            this.appPropsNamePattern = '/' + this.appPropsName.substring(0, index) + "*.prop*";
        }
        if (this.jtxAnnotations == null) {
            this.jtxAnnotations = new Class[]{Transaction.class, ReadWriteTransaction.class};
        }
        if (this.jtxScopePattern == null) {
            this.jtxScopePattern = "$class";
        }
        if (this.appDir == null) {
            this.resolveAppDir(this.appPropsName);
        }
        System.setProperty(APP_DIR, this.appDir);
        System.setProperty(APP_WEB, Boolean.toString(this.isWebApplication));
    }

    protected void initLogger() {
        if (log != null) {
            return;
        }
        log = LoggerFactory.getLogger(DefaultAppCore.class);
        log.info("app dir: " + this.appDir);
    }

    protected void resolveAppDir(String classPathFileName) {
        URL url = ClassLoaderUtil.getResourceUrl((String)classPathFileName);
        if (url == null) {
            throw new AppException("Failed to resolve app dir, missing: " + classPathFileName);
        }
        String protocol = url.getProtocol();
        if (!protocol.equals("file")) {
            try {
                url = new URL(url.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.appDir = url.getFile();
        int ndx = this.appDir.indexOf("WEB-INF");
        this.isWebApplication = ndx != -1;
        this.appDir = this.isWebApplication ? this.appDir.substring(0, ndx) : SystemUtil.workingFolder();
    }

    protected void ready() {
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initCore();
        this.initLogger();
        this.initProps();
        this.initScanner();
        this.initialized = true;
    }

    public void start() {
        this.init();
        this.ready();
        try {
            this.startProxetta();
            this.startPetite();
            this.startDb();
            this.startApp();
            log.info("app started");
        }
        catch (RuntimeException rex) {
            if (log != null) {
                log.error(rex.toString(), (Throwable)rex);
            } else {
                System.out.println(rex.toString());
                rex.printStackTrace();
            }
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw rex;
        }
    }

    public void stop() {
        if (log != null) {
            log.info("shutting down...");
        }
        this.stopApp();
        this.stopDb();
        this.stopPetite();
        if (log != null) {
            log.info("app stopped");
        }
    }

    public Props getAppProps() {
        return this.appProps;
    }

    protected void initProps() {
        if (this.appProps != null) {
            return;
        }
        this.appProps = this.createProps();
        this.appProps.loadSystemProperties("sys");
        this.appProps.loadEnvironment("env");
        PropsUtil.loadFromClasspath((Props)this.appProps, (String[])new String[]{this.appPropsNamePattern});
        if (this.appPropsProfiles != null) {
            this.appProps.setActiveProfiles(this.appPropsProfiles);
        }
    }

    protected Props createProps() {
        Props props = new Props();
        props.setSkipEmptyProps(true);
        props.setIgnoreMissingMacros(true);
        return props;
    }

    public AppScanner getAppScanner() {
        return this.appScanner;
    }

    protected void initScanner() {
        if (this.appScanner != null) {
            return;
        }
        this.appScanner = new AppScanner(this);
    }

    public ProxyProxetta getProxetta() {
        return this.proxetta;
    }

    protected void startProxetta() {
        log.info("proxetta initialization");
        this.proxetta = ProxyProxetta.withAspects((ProxyAspect[])this.createAppAspects());
    }

    protected ProxyAspect[] createAppAspects() {
        return new ProxyAspect[]{this.createTxProxyAspects()};
    }

    protected ProxyAspect createTxProxyAspects() {
        return new ProxyAspect(AnnotationTxAdvice.class, (ProxyPointcut)new MethodAnnotationPointcut(this.jtxAnnotations){

            public boolean apply(MethodInfo methodInfo) {
                return this.isPublic(methodInfo) && this.isTopLevelMethod(methodInfo) && super.apply(methodInfo);
            }
        });
    }

    public PetiteContainer getPetite() {
        return this.petite;
    }

    protected void startPetite() {
        log.info("petite initialization");
        this.petite = this.createPetiteContainer();
        log.info("app in web: " + Boolean.valueOf(this.isWebApplication));
        if (!this.isWebApplication) {
            this.petite.registerScope(SessionScope.class, (Scope)new SingletonScope());
        }
        this.petite.defineParameters(this.appProps);
        this.petite.addBean(PETITE_SCAN, (Object)this.appScanner);
        this.registerPetiteContainerBeans(this.petite);
        this.petite.addBean(PETITE_CORE, (Object)this);
        this.petite.addBean(PETITE_PROPS, (Object)this.appProps);
    }

    protected void registerPetiteContainerBeans(PetiteContainer petiteContainer) {
        AutomagicPetiteConfigurator pcfg = new AutomagicPetiteConfigurator();
        this.appScanner.configure((ClassFinder)pcfg);
        pcfg.configure(petiteContainer);
    }

    protected PetiteContainer createPetiteContainer() {
        return new ProxettaAwarePetiteContainer(this.proxetta);
    }

    protected void stopPetite() {
        if (this.petite != null) {
            this.petite.shutdown();
        }
    }

    public JtxTransactionManager getJtxManager() {
        return this.jtxManager;
    }

    protected void startDb() {
        if (!this.useDatabase) {
            log.info("database is not used");
            return;
        }
        log.info("database initialization");
        this.connectionProvider = this.createConnectionProvider();
        this.petite.addBean(PETITE_DBPOOL, (Object)this.connectionProvider);
        this.connectionProvider.init();
        this.checkConnectionProvider();
        this.jtxManager = this.createJtxTransactionManager(this.connectionProvider);
        this.jtxManager.setValidateExistingTransaction(true);
        AnnotationTxAdviceManager annTxAdviceManager = new AnnotationTxAdviceManager(this.jtxManager, this.jtxScopePattern);
        annTxAdviceManager.registerAnnotations((Class[])this.jtxAnnotations);
        AnnotationTxAdviceSupport.manager = annTxAdviceManager;
        DbJtxSessionProvider sessionProvider = new DbJtxSessionProvider(this.jtxManager);
        DbManager dbManager = DbManager.getInstance();
        dbManager.setConnectionProvider(this.connectionProvider);
        dbManager.setSessionProvider((DbSessionProvider)sessionProvider);
        this.petite.addBean(PETITE_DB, (Object)dbManager);
        DbOomManager dbOomManager = DbOomManager.getInstance();
        this.petite.addBean(PETITE_DBOOM, (Object)dbOomManager);
        this.registerDbEntities(dbOomManager);
    }

    protected void registerDbEntities(DbOomManager dbOomManager) {
        AutomagicDbOomConfigurator dbcfg = new AutomagicDbOomConfigurator();
        this.appScanner.configure((ClassFinder)dbcfg);
        dbcfg.configure(dbOomManager);
    }

    protected JtxTransactionManager createJtxTransactionManager(ConnectionProvider connectionProvider) {
        return new DbJtxTransactionManager(connectionProvider);
    }

    protected ConnectionProvider createConnectionProvider() {
        return new CoreConnectionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionProvider() {
        Connection connection = this.connectionProvider.getConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String name = databaseMetaData.getDatabaseProductName();
            String version = databaseMetaData.getDatabaseProductVersion();
            if (log.isInfoEnabled()) {
                log.info("Connected to database: " + name + " v" + version);
            }
        }
        catch (SQLException sex) {
            log.error("DB connection failed: ", (Throwable)sex);
        }
        finally {
            this.connectionProvider.closeConnection(connection);
        }
    }

    protected void stopDb() {
        if (!this.useDatabase) {
            return;
        }
        if (log != null) {
            log.info("database shutdown");
        }
        if (this.jtxManager != null) {
            this.jtxManager.close();
        }
        if (this.connectionProvider != null) {
            this.connectionProvider.close();
        }
    }

    protected void startApp() {
        this.appInit = (AppInit)this.petite.getBean(PETITE_INIT);
        if (this.appInit != null) {
            this.appInit.init();
        }
    }

    protected void stopApp() {
        if (this.appInit != null) {
            this.appInit.stop();
        }
    }
}

