/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.jspp;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.joy.jspp.Jspp;
import jodd.joy.jspp.JsppException;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.madvoc.result.ServletDispatcherResult;
import jodd.util.StringUtil;

public abstract class ServletDispatcherResultWithJspp
extends ServletDispatcherResult {
    private static final Logger log = LoggerFactory.getLogger(ServletDispatcherResultWithJspp.class);
    protected String macrosPath = "jspp";
    protected Jspp jspp;

    protected String convertToNewName(String jspFile) {
        String extension = FileNameUtil.getExtension((String)jspFile);
        jspFile = StringUtil.substring((String)jspFile, (int)0, (int)(-extension.length() - 1));
        return jspFile + "-jspp." + extension;
    }

    protected String processTarget(ServletContext servletContext, String target) {
        String jspPath = servletContext.getRealPath(target);
        if (jspPath == null) {
            throw new MadvocException("Real path not found: " + target);
        }
        File jspFile = new File(jspPath);
        File targetFile = new File(this.convertToNewName(jspPath));
        target = this.convertToNewName(target);
        if (!targetFile.exists() || FileUtil.isNewer((File)jspFile, (File)targetFile)) {
            if (log.isDebugEnabled()) {
                log.debug("JSPP target: " + target);
            }
            if (this.jspp == null) {
                this.jspp = this.createJspp(servletContext);
            }
            try {
                this.preprocess(jspFile, targetFile);
            }
            catch (IOException ioex) {
                throw new JsppException(ioex);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("JSPP ok: " + target);
        }
        return target;
    }

    protected Jspp createJspp(ServletContext servletContext) {
        Jspp jspp = new Jspp();
        String rootFolder = servletContext.getRealPath("/");
        jspp.setJsppMacroFolder(new File(rootFolder, this.macrosPath));
        return jspp;
    }

    protected void preprocess(File jspFile, File targetFile) throws IOException {
        String jsp = FileUtil.readString((File)jspFile);
        String newJsp = this.jspp.process(jsp);
        FileUtil.writeString((File)targetFile, (String)newJsp);
    }
}

