/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.db;

import java.util.HashMap;
import java.util.Map;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.DbOomQuery;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.mutable.MutableLong;
import jodd.petite.meta.PetiteBean;

@PetiteBean
public class DbIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(DbIdGenerator.class);
    protected Map<Class<?>, MutableLong> entityIdsMap = new HashMap();

    public synchronized void reset() {
        this.entityIdsMap.clear();
    }

    public synchronized long nextId(Class entityType) {
        MutableLong lastId = this.entityIdsMap.get(entityType);
        if (lastId == null) {
            DbOomManager dbOomManager = DbOomManager.getInstance();
            DbEntityDescriptor ded = dbOomManager.lookupType(entityType);
            String tableName = ded.getTableName();
            String idColumn = ded.getIdColumnName();
            DbOomQuery dbOomQuery = DbOomQuery.query((String)("select max(" + idColumn + ") from " + tableName));
            long lastLong = dbOomQuery.executeCountAndClose();
            if (log.isDebugEnabled()) {
                log.debug("Last id for " + entityType.getName() + " is " + lastLong);
            }
            lastId = new MutableLong(lastLong);
            this.entityIdsMap.put(entityType, lastId);
        }
        ++lastId.value;
        return lastId.value;
    }
}

