/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.io.StreamUtil;

public class HttpTunnel {
    protected int threadPoolSize = 10;
    protected int socketBacklog = 100;
    protected int listenPort = 8888;
    protected String targetHost = "localhost";
    protected int targetPort = 8080;
    protected ExecutorService executorService;
    protected volatile boolean running;
    protected ServerSocket serverSocket;

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.listenPort, this.socketBacklog);
        this.serverSocket.setReuseAddress(true);
        this.executorService = Executors.newFixedThreadPool(this.threadPoolSize);
        this.running = true;
        while (this.running) {
            Socket socket = this.serverSocket.accept();
            socket.setKeepAlive(false);
            this.executorService.execute(this.onSocketConnection(socket));
        }
        this.executorService.shutdown();
    }

    protected Runnable onSocketConnection(Socket socket) {
        return new HttpTunnelConnection(socket);
    }

    public void stop() {
        this.running = false;
        this.executorService.shutdown();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class HttpTunnelConnection
    implements Runnable {
        protected final Socket socket;

        public HttpTunnelConnection(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                this.tunnel();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }

        protected void onRequest(HttpRequest request) {
        }

        protected void onResponse(HttpResponse response) {
        }

        protected void tunnel() throws IOException {
            InputStream socketInput = this.socket.getInputStream();
            HttpRequest request = HttpRequest.readFrom(socketInput);
            Socket clientSocket = new Socket();
            clientSocket.connect(new InetSocketAddress(HttpTunnel.this.targetHost, HttpTunnel.this.targetPort));
            request.host(HttpTunnel.this.targetHost);
            request.port(HttpTunnel.this.targetPort);
            request.setHostHeader();
            this.onRequest(request);
            OutputStream out = clientSocket.getOutputStream();
            request.sendTo(out);
            InputStream in = clientSocket.getInputStream();
            HttpResponse response = HttpResponse.readFrom(in);
            StreamUtil.close((Closeable)in);
            StreamUtil.close((Closeable)out);
            try {
                clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (response.body() != null) {
                response.removeHeader("Transfer-Encoding");
                response.contentLength(response.body().length());
            }
            this.onResponse(response);
            OutputStream socketOutput = this.socket.getOutputStream();
            response.sendTo(socketOutput);
            StreamUtil.close((Closeable)socketInput);
            StreamUtil.close((Closeable)socketOutput);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

