/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.up;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jodd.http.up.Uploadable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayUploadable
implements Uploadable<byte[]> {
    protected final byte[] byteArray;
    protected final String fileName;
    protected final String mimeType;

    public ByteArrayUploadable(byte[] byteArray, String fileName) {
        this.byteArray = byteArray;
        this.fileName = fileName;
        this.mimeType = null;
    }

    public ByteArrayUploadable(byte[] byteArray, String fileName, String mimeType) {
        this.byteArray = byteArray;
        this.fileName = fileName;
        this.mimeType = mimeType;
    }

    @Override
    public byte[] getContent() {
        return this.byteArray;
    }

    @Override
    public byte[] getBytes() {
        return this.byteArray;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getSize() {
        return this.byteArray.length;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }
}

