/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.LinkedHashMap;
import jodd.util.ArraysUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpValuesMap<T>
extends LinkedHashMap<String, T[]> {
    public static HttpValuesMap<String> ofStrings() {
        return new HttpValuesMap<String>(){

            protected String[] createNewArray() {
                return new String[1];
            }
        };
    }

    public static HttpValuesMap<Object> ofObjects() {
        return new HttpValuesMap<Object>(){

            @Override
            protected Object[] createNewArray() {
                return new Object[1];
            }
        };
    }

    public void set(String key, T value) {
        this.remove(key);
        this.add(key, value);
    }

    protected abstract T[] createNewArray();

    public void add(String key, T value) {
        if (value == null) {
            this.put(key, null);
            return;
        }
        Object[] values = (Object[])this.get(key);
        if (values == null) {
            values = this.createNewArray();
            values[0] = value;
        } else {
            values = ArraysUtil.append((Object[])values, value);
        }
        super.put(key, values);
    }

    public T getFirst(String key) {
        Object[] value = (Object[])this.get(key);
        if (value == null) {
            return null;
        }
        return (T)value[0];
    }

    public String[] getStrings(String key) {
        Object[] values = (Object[])this.get(key);
        if (values == null) {
            return null;
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            strings[i] = value.toString();
        }
        return strings;
    }
}

