/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jodd.http.Cookie;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.HttpValuesMap;
import jodd.http.JoddHttp;
import jodd.http.ProxyInfo;

public class HttpBrowser {
    protected HttpConnectionProvider httpConnectionProvider;
    protected HttpRequest httpRequest;
    protected HttpResponse httpResponse;
    protected Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    protected HttpValuesMap<String> defaultHeaders = HttpValuesMap.ofStrings();
    protected boolean keepAlive;
    protected long elapsedTime;

    public HttpBrowser() {
        this.httpConnectionProvider = JoddHttp.httpConnectionProvider;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpBrowser setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public HttpBrowser setProxyInfo(ProxyInfo proxyInfo) {
        this.httpConnectionProvider.useProxy(proxyInfo);
        return this;
    }

    public HttpBrowser setHttpConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        this.httpConnectionProvider = httpConnectionProvider;
        return this;
    }

    public HttpBrowser setDefaultHeader(String name, String value) {
        this.defaultHeaders.add(name, value);
        return this;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getPage() {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.bodyText();
    }

    public HttpResponse sendRequest(HttpRequest httpRequest) {
        this.elapsedTime = System.currentTimeMillis();
        while (true) {
            String newPath;
            this.httpRequest = httpRequest;
            HttpResponse previouseResponse = this.httpResponse;
            this.httpResponse = null;
            this.addDefaultHeaders(httpRequest);
            this.addCookies(httpRequest);
            if (!this.keepAlive) {
                httpRequest.open(this.httpConnectionProvider);
            } else if (previouseResponse == null) {
                httpRequest.open(this.httpConnectionProvider).connectionKeepAlive(true);
            } else {
                httpRequest.keepAlive(previouseResponse, true);
            }
            this.httpResponse = httpRequest.send();
            this.readCookies(this.httpResponse);
            int statusCode = this.httpResponse.statusCode();
            if (statusCode == 301) {
                newPath = this.location(this.httpResponse);
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode == 302 || statusCode == 303) {
                newPath = this.location(this.httpResponse);
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode != 307) break;
            newPath = this.location(this.httpResponse);
            String originalMethod = httpRequest.method();
            httpRequest = new HttpRequest().method(originalMethod).set(newPath);
        }
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        return this.httpResponse;
    }

    protected void addDefaultHeaders(HttpRequest httpRequest) {
        Set entries = this.defaultHeaders.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            if (httpRequest.headers.containsKey(name)) continue;
            httpRequest.headers.put(name, entry.getValue());
        }
    }

    protected String location(HttpResponse httpResponse) {
        String location = httpResponse.header("location");
        if (location.startsWith("/")) {
            HttpRequest httpRequest = httpResponse.getHttpRequest();
            location = httpRequest.hostUrl() + location;
        }
        return location;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void close() {
        if (this.httpResponse != null) {
            this.httpResponse.close();
        }
    }

    protected void readCookies(HttpResponse httpResponse) {
        String[] newCookies = httpResponse.headers("set-cookie");
        if (newCookies != null) {
            for (String cookieValue : newCookies) {
                Cookie cookie = new Cookie(cookieValue);
                this.cookies.put(cookie.getName(), cookie);
            }
        }
    }

    protected void addCookies(HttpRequest httpRequest) {
        StringBuilder cookieString = new StringBuilder();
        boolean first = true;
        if (!this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies.values()) {
                Integer maxAge = cookie.getMaxAge();
                if (maxAge != null && maxAge == 0) continue;
                if (!first) {
                    cookieString.append("; ");
                }
                first = false;
                cookieString.append(cookie.getName());
                cookieString.append('=');
                cookieString.append(cookie.getValue());
            }
            httpRequest.header("cookie", cookieString.toString(), true);
        }
    }
}

