/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import jodd.http.HttpTransfer;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.StreamUtil;
import jodd.util.StringUtil;

public class Http {
    public static HttpTransfer createRequest(String method, String fullUrl) throws IOException {
        int port;
        URL url = new URL(fullUrl);
        String path = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            path = url.getPath() + '?' + query;
        }
        if ((port = url.getPort()) == -1) {
            port = 80;
        }
        String host = url.getHost();
        return Http.createRequest(method, host, port, path);
    }

    public static HttpTransfer createRequest(String method, String hostName, int port, String path) {
        HttpTransfer httpTransfer = new HttpTransfer();
        httpTransfer.setMethod(method);
        httpTransfer.setPath(path);
        httpTransfer.setHost(hostName);
        httpTransfer.setPort(port);
        String host = hostName;
        if (port != 80) {
            host = host + (58 + port);
        }
        httpTransfer.addHeader("Host", host);
        return httpTransfer;
    }

    public static HttpTransfer readRequest(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
        HttpTransfer httpTransfer = new HttpTransfer();
        String line = reader.readLine();
        String[] s = StringUtil.splitc((String)line, (char)' ');
        httpTransfer.setMethod(s[0]);
        httpTransfer.setPath(s[1]);
        httpTransfer.setHttpVersion(s[2]);
        Http.readHeaders(httpTransfer, reader);
        Http.readBody(httpTransfer, reader);
        return httpTransfer;
    }

    public static HttpTransfer createResponse(int statusCode, String statusPhrase) {
        HttpTransfer httpTransfer = new HttpTransfer();
        httpTransfer.setStatusCode(statusCode);
        httpTransfer.setStatusPhrase(statusPhrase);
        return httpTransfer;
    }

    public static HttpTransfer readResponse(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
        HttpTransfer httpTransfer = new HttpTransfer();
        String line = reader.readLine().trim();
        int ndx = line.indexOf(32);
        httpTransfer.setHttpVersion(line.substring(0, ndx));
        int ndx2 = line.indexOf(32, ndx + 1);
        httpTransfer.setStatusCode(Integer.parseInt(line.substring(ndx, ndx2).trim()));
        httpTransfer.setStatusPhrase(line.substring(ndx2).trim());
        Http.readHeaders(httpTransfer, reader);
        Http.readBody(httpTransfer, reader);
        return httpTransfer;
    }

    public static HttpTransfer readResponse(HttpURLConnection huc) throws IOException {
        String key;
        HttpTransfer httpTransfer = new HttpTransfer();
        String line = huc.getHeaderField(0);
        int ndx = line.indexOf(32);
        httpTransfer.setHttpVersion(line.substring(0, ndx));
        int ndx2 = line.indexOf(32, ndx + 1);
        httpTransfer.setStatusCode(Integer.parseInt(line.substring(ndx, ndx2).trim()));
        httpTransfer.setStatusPhrase(line.substring(ndx2).trim());
        int count = 1;
        while ((key = huc.getHeaderFieldKey(count)) != null) {
            String value = huc.getHeaderField(count);
            httpTransfer.addHeader(key, value);
            ++count;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(huc.getInputStream(), "ISO-8859-1"));
        Http.readBody(httpTransfer, reader);
        return httpTransfer;
    }

    protected static void readHeaders(HttpTransfer httpTransfer, BufferedReader reader) throws IOException {
        String line;
        while (!StringUtil.isBlank((String)(line = reader.readLine()))) {
            int ndx = line.indexOf(58);
            if (ndx != -1) {
                httpTransfer.addHeader(line.substring(0, ndx), line.substring(ndx + 1));
                continue;
            }
            throw new IOException("Invalid header " + line);
        }
    }

    protected static void readBody(HttpTransfer httpTransfer, BufferedReader reader) throws IOException {
        String transferEncoding;
        FastByteArrayOutputStream fbaos;
        String contentLen = httpTransfer.getHeader("Content-Length");
        if (contentLen != null) {
            int len = Integer.parseInt(contentLen);
            fbaos = new FastByteArrayOutputStream(len);
            StreamUtil.copy((Reader)reader, (OutputStream)fbaos, (String)"ISO-8859-1", (int)len);
            httpTransfer.setBody(fbaos.toByteArray());
        }
        if ((transferEncoding = httpTransfer.getHeader("Transfer-Encoding")) != null && transferEncoding.equalsIgnoreCase("chunked")) {
            String line;
            fbaos = new FastByteArrayOutputStream();
            while (!StringUtil.isBlank((String)(line = reader.readLine()))) {
                int len = Integer.parseInt(line, 16);
                if (len == 0) continue;
                StreamUtil.copy((Reader)reader, (OutputStream)fbaos, (String)"ISO-8859-1", (int)len);
                reader.readLine();
            }
            httpTransfer.setBody(fbaos.toByteArray());
        }
    }
}

