/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import jodd.decora.DecoraException;
import jodd.io.FileUtil;

public class DecoraManager {
    private static DecoraManager DECORA_MANAGER;
    public static final String DEFAULT_DECORATOR = "/decora/main.jsp";
    protected boolean decorateErrorPages;
    protected Map<String, char[]> contentMap;
    protected Map<String, File> filesMap;

    public static DecoraManager get() {
        return Objects.requireNonNull(DECORA_MANAGER, "Only one instance of DecoraManager should be used.");
    }

    public DecoraManager() {
        DECORA_MANAGER = this;
    }

    public boolean isDecorateErrorPages() {
        return this.decorateErrorPages;
    }

    public void setDecorateErrorPages(boolean decorateErrorPages) {
        this.decorateErrorPages = decorateErrorPages;
    }

    public DecoraManager registerDecorator(String path, char[] content) {
        if (this.contentMap == null) {
            this.contentMap = new HashMap<String, char[]>();
        }
        this.contentMap.put(path, content);
        return this;
    }

    public DecoraManager registerDecorator(String path, File decorator) {
        if (this.filesMap == null) {
            this.filesMap = new HashMap<String, File>();
        }
        this.filesMap.put(path, decorator);
        return this;
    }

    public char[] lookupDecoratorContent(String path) {
        if (this.contentMap != null) {
            char[] data = this.contentMap.get(path);
            if (data != null) {
                return data;
            }
            File file = this.filesMap.get(path);
            if (file != null) {
                try {
                    return FileUtil.readChars((File)file);
                }
                catch (IOException e) {
                    throw new DecoraException("Unable to read Decrator files", e);
                }
            }
        }
        return null;
    }

    public boolean decorateRequest(HttpServletRequest request) {
        return true;
    }

    public boolean decorateContentType(String contentType, String mimeType, String encoding) {
        return true;
    }

    public boolean decorateStatusCode(int statusCode) {
        return statusCode == 200 || this.decorateErrorPages && statusCode >= 400;
    }

    public String resolveDecorator(HttpServletRequest request, String actionPath) {
        if (actionPath.endsWith(".html")) {
            return DEFAULT_DECORATOR;
        }
        return null;
    }
}

