/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jodd.jtx.JtxIsolationLevel;
import jodd.jtx.JtxPropagationBehavior;
import jodd.jtx.meta.Transaction;
import jodd.util.AnnotationParser;

public class TransactionAnnotationValues
implements Transaction {
    protected final Class<? extends Annotation> annotationType;
    protected final JtxPropagationBehavior propagation;
    protected final JtxIsolationLevel isolation;
    protected final boolean readOnly;
    protected final int timeout;

    public static AnnotationParser parserFor(Class<? extends Annotation> annotationClass) {
        return new AnnotationParser(annotationClass, Transaction.class);
    }

    public static TransactionAnnotationValues of(AnnotationParser annotationParser, AnnotatedElement annotatedElement) {
        if (!annotationParser.hasAnnotationOn(annotatedElement)) {
            return null;
        }
        return new TransactionAnnotationValues(annotationParser.of(annotatedElement));
    }

    private TransactionAnnotationValues(AnnotationParser.Reader reader) {
        this.annotationType = reader.annotationType();
        this.propagation = (JtxPropagationBehavior)((Object)reader.readElement("propagation"));
        this.isolation = (JtxIsolationLevel)((Object)reader.readElement("isolation"));
        this.readOnly = reader.readBoolean("readOnly", false);
        this.timeout = reader.readInt("timeout", -1);
    }

    @Override
    public JtxPropagationBehavior propagation() {
        return this.propagation;
    }

    @Override
    public JtxIsolationLevel isolation() {
        return this.isolation;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return null;
    }
}

