/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomConfig;
import jodd.db.oom.DbOomException;
import jodd.db.oom.NamedValuesHashMap;
import jodd.db.oom.naming.ColumnNamingStrategy;
import jodd.db.oom.naming.TableNamingStrategy;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;
import jodd.util.TypeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbEntityManager {
    private static final Logger log = LoggerFactory.getLogger(DbEntityManager.class);
    private final DbOomConfig dbOomConfig;
    protected String[] primitiveEntitiesPrefixes = new String[]{"java.lang.", "jodd.mutable.", Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Short.TYPE.getName(), Boolean.TYPE.getName(), Byte.TYPE.getName()};
    protected TypeCache<DbEntityDescriptor> descriptorsMap = TypeCache.createDefault();
    protected Map<String, DbEntityDescriptor> entityNamesMap = new HashMap<String, DbEntityDescriptor>();
    protected Map<String, DbEntityDescriptor> tableNamesMap = new NamedValuesHashMap<DbEntityDescriptor>();

    public DbEntityManager(DbOomConfig dbOomConfig) {
        this.dbOomConfig = dbOomConfig;
    }

    public String[] getPrimitiveEntitiesPrefixes() {
        return this.primitiveEntitiesPrefixes;
    }

    public void setPrimitiveEntitiesPrefixes(String ... primitiveEntitiesPrefixes) {
        this.primitiveEntitiesPrefixes = primitiveEntitiesPrefixes;
    }

    public <E> DbEntityDescriptor<E> lookupType(Class<E> type) {
        String typeName = type.getName();
        if (StringUtil.startsWithOne((String)typeName, (String[])this.primitiveEntitiesPrefixes) != -1) {
            return null;
        }
        DbEntityDescriptor<E> ded = (DbEntityDescriptor<E>)this.descriptorsMap.get(type);
        if (ded == null) {
            ded = this.registerType(type);
        }
        return ded;
    }

    public DbEntityDescriptor lookupName(String typeName) {
        return this.entityNamesMap.get(typeName);
    }

    public DbEntityDescriptor lookupTableName(String tableName) {
        return this.tableNamesMap.get(tableName);
    }

    public <E> DbEntityDescriptor<E> registerType(Class<E> type) {
        DbEntityDescriptor<E> ded = this.createDbEntityDescriptor(type);
        DbEntityDescriptor<E> existing = (DbEntityDescriptor<E>)this.descriptorsMap.put(type, ded);
        if (log.isDebugEnabled()) {
            log.debug("Register " + type.getName() + " as " + ded.getTableName());
        }
        if (existing != null) {
            if (ded.getType() == type) {
                return ded;
            }
            throw new DbOomException("Type already registered: " + existing.getType());
        }
        existing = this.entityNamesMap.put(ded.getEntityName(), ded);
        if (existing != null) {
            throw new DbOomException("Name '" + ded.getEntityName() + "' already mapped to an entity: " + existing.getType());
        }
        return ded;
    }

    public <E> DbEntityDescriptor<E> registerEntity(Class<E> type) {
        DbEntityDescriptor<E> ded = this.registerType(type);
        DbEntityDescriptor<E> existing = this.tableNamesMap.put(ded.getTableName(), ded);
        if (existing != null) {
            if (ded.getType() == type) {
                return ded;
            }
            throw new DbOomException("Entity registration failed! Table '" + ded.getTableName() + "' already mapped to an entity: " + existing.getType());
        }
        return ded;
    }

    public <E> DbEntityDescriptor<E> registerEntity(Class<E> type, boolean force) {
        if (force) {
            this.removeEntity(type);
        }
        return this.registerEntity(type);
    }

    public <E> DbEntityDescriptor<E> removeEntity(Class<E> type) {
        DbEntityDescriptor<E> ded = (DbEntityDescriptor<E>)this.descriptorsMap.remove(type);
        if (ded == null) {
            ded = this.createDbEntityDescriptor(type);
        }
        this.entityNamesMap.remove(ded.getEntityName());
        this.tableNamesMap.remove(ded.getTableName());
        return ded;
    }

    protected <E> DbEntityDescriptor<E> createDbEntityDescriptor(Class<E> type) {
        String schemaName = this.dbOomConfig.getSchemaName();
        TableNamingStrategy tableNames = this.dbOomConfig.getTableNames();
        ColumnNamingStrategy columnNames = this.dbOomConfig.getColumnNames();
        return new DbEntityDescriptor<E>(type, schemaName, tableNames, columnNames);
    }

    public int getTotalNames() {
        return this.entityNamesMap.size();
    }

    public int getTotalTableNames() {
        return this.tableNamesMap.size();
    }

    public int getTotalTypes() {
        return this.descriptorsMap.size();
    }

    public void reset() {
        this.descriptorsMap.clear();
        this.entityNamesMap.clear();
        this.tableNamesMap.clear();
    }

    public <E> E createEntityInstance(Class<E> type) {
        try {
            return (E)ClassUtil.newInstance(type);
        }
        catch (Exception ex) {
            throw new DbOomException(ex);
        }
    }

    public void forEachEntity(Consumer<DbEntityDescriptor> consumer) {
        this.descriptorsMap.forEachValue(consumer);
    }
}

