/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.meta.DbTable;
import jodd.util.StringPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomagicDbOomConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicDbOomConfigurator.class);
    protected final boolean registerAsEntities;
    protected final DbEntityManager dbEntityManager;
    private String[] packages = StringPool.EMPTY_ARRAY;

    public AutomagicDbOomConfigurator setPackages(String ... packages) {
        this.packages = packages;
        return this;
    }

    public AutomagicDbOomConfigurator(DbEntityManager dbEntityManager, boolean registerAsEntities) {
        this.dbEntityManager = dbEntityManager;
        this.registerAsEntities = registerAsEntities;
    }

    public void configure() {
        long elapsed = System.currentTimeMillis();
        String petiteBeanAnnotation = DbTable.class.getName();
        try (ScanResult scanResult = new ClassGraph().acceptPackages(this.packages).enableAnnotationInfo().enableClassInfo().scan();){
            for (ClassInfo routeClassInfo : scanResult.getClassesWithAnnotation(petiteBeanAnnotation)) {
                Class beanClass = routeClassInfo.loadClass();
                if (this.registerAsEntities) {
                    this.dbEntityManager.registerEntity(beanClass);
                    continue;
                }
                this.dbEntityManager.registerType(beanClass);
            }
        }
        log.info("DbEntityManager configured in " + elapsed + "ms. Total entities: " + this.dbEntityManager.getTotalNames());
    }
}

