/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import jodd.db.oom.DbEntityDescriptor;
import jodd.db.type.SqlType;
import jodd.util.StringUtil;

public class DbEntityColumnDescriptor
implements Comparable {
    protected final DbEntityDescriptor dbEntityDescriptor;
    protected final String columnName;
    protected final String columnNameForQuery;
    protected final String propertyName;
    protected final Class propertyType;
    protected final boolean isId;
    protected final Class<? extends SqlType> sqlTypeClass;
    protected int dbSqlType = Integer.MAX_VALUE;

    public DbEntityColumnDescriptor(DbEntityDescriptor ded, String columnName, String fieldName, Class fieldType, boolean isId, Class<? extends SqlType> sqlTypeClass) {
        this.dbEntityDescriptor = ded;
        this.propertyName = fieldName;
        this.propertyType = fieldType;
        this.isId = isId;
        this.sqlTypeClass = sqlTypeClass;
        this.columnNameForQuery = columnName;
        this.columnName = StringUtil.detectQuoteChar((String)this.columnNameForQuery) != '\u0000' ? StringUtil.substring((String)this.columnNameForQuery, (int)1, (int)-1) : this.columnNameForQuery;
    }

    public DbEntityDescriptor getDbEntityDescriptor() {
        return this.dbEntityDescriptor;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnNameForQuery() {
        return this.columnNameForQuery;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public boolean isId() {
        return this.isId;
    }

    public Class<? extends SqlType> getSqlTypeClass() {
        return this.sqlTypeClass;
    }

    public int getDbSqlType() {
        return this.dbSqlType;
    }

    public void updateDbSqlType(int dbSqlType) {
        if (this.dbSqlType == Integer.MAX_VALUE) {
            this.dbSqlType = dbSqlType;
        }
    }

    public int compareTo(Object o) {
        DbEntityColumnDescriptor that = (DbEntityColumnDescriptor)o;
        if (this.isId != that.isId) {
            return this.isId ? -1 : 1;
        }
        return this.columnName.compareTo(that.columnName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DbEntityColumnDescriptor that = (DbEntityColumnDescriptor)o;
        return this.columnName.equals(that.columnName);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public String toString() {
        return "DbEntityColumnDescriptor{columnName='" + this.columnName + '\'' + ", propertyName='" + this.propertyName + '\'' + ", isId=" + this.isId + '}';
    }
}

