/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.function.Consumer;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.DbOomException;
import jodd.db.oom.meta.DbTable;
import jodd.io.findfile.ClassScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.function.Consumers;

public class AutomagicDbOomConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicDbOomConfigurator.class);
    protected static final byte[] DB_TABLE_ANNOTATION_BYTES = ClassScanner.bytecodeSignatureOfType(DbTable.class);
    protected final boolean registerAsEntities;
    protected final DbEntityManager dbEntityManager;
    private final Consumers<ClassScanner> classScannerConsumers = new Consumers(new Consumer[0]);

    public AutomagicDbOomConfigurator(DbEntityManager dbEntityManager, boolean registerAsEntities) {
        this.dbEntityManager = dbEntityManager;
        this.registerAsEntities = registerAsEntities;
    }

    public AutomagicDbOomConfigurator withScanner(Consumer<ClassScanner> scannerConsumer) {
        this.classScannerConsumers.add(scannerConsumer);
        return this;
    }

    public void configure() {
        long elapsed = System.currentTimeMillis();
        ClassScanner classScanner = new ClassScanner();
        classScanner.detectEntriesMode(true);
        classScanner.scanDefaultClasspath();
        this.classScannerConsumers.accept((Object)classScanner);
        this.registerAsConsumer(classScanner);
        try {
            classScanner.start();
        }
        catch (Exception ex) {
            throw new DbOomException("Scan classpath error", ex);
        }
        elapsed = System.currentTimeMillis() - elapsed;
        if (log.isInfoEnabled()) {
            log.info("DbEntityManager configured in " + elapsed + "ms. Total entities: " + this.dbEntityManager.getTotalNames());
        }
    }

    public void registerAsConsumer(ClassScanner classScanner) {
        classScanner.registerEntryConsumer(classPathEntry -> {
            Class beanClass;
            if (!classPathEntry.isTypeSignatureInUse(DB_TABLE_ANNOTATION_BYTES)) {
                return;
            }
            try {
                beanClass = classPathEntry.loadClass();
            }
            catch (ClassNotFoundException cnfex) {
                throw new DbOomException("Entry class not found: " + classPathEntry.name(), cnfex);
            }
            if (beanClass == null) {
                return;
            }
            DbTable dbTable = beanClass.getAnnotation(DbTable.class);
            if (dbTable == null) {
                return;
            }
            if (this.registerAsEntities) {
                this.dbEntityManager.registerEntity(beanClass);
            } else {
                this.dbEntityManager.registerType(beanClass);
            }
        });
    }
}

