/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import jodd.typeconverter.Converter;
import jodd.typeconverter.TypeConverterManager;

public class DbUtil {
    public static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static long getFirstLong(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getLong(1);
        }
        return -1L;
    }

    public static int getFirstInt(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        return -1;
    }

    public static Object getFirstObject(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getObject(1);
        }
        return null;
    }

    public static void setPreparedStatementObject(PreparedStatement preparedStatement, int index, Object value, int targetSqlType) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 0);
            return;
        }
        switch (targetSqlType) {
            case -1: 
            case 1: 
            case 12: {
                preparedStatement.setString(index, Converter.get().toString(value));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                preparedStatement.setInt(index, Converter.get().toIntValue(value));
                break;
            }
            case -5: {
                preparedStatement.setLong(index, Converter.get().toLongValue(value));
                break;
            }
            case -7: 
            case 16: {
                preparedStatement.setBoolean(index, Converter.get().toBooleanValue(value));
                break;
            }
            case 91: {
                preparedStatement.setDate(index, (Date)TypeConverterManager.get().convertType(value, Date.class));
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(index, Converter.get().toBigDecimal(value));
                break;
            }
            case 8: {
                preparedStatement.setDouble(index, Converter.get().toDoubleValue(value));
                break;
            }
            case 6: 
            case 7: {
                preparedStatement.setFloat(index, Converter.get().toFloatValue(value));
                break;
            }
            case 92: {
                preparedStatement.setTime(index, (Time)TypeConverterManager.get().convertType(value, Time.class));
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(index, (Timestamp)TypeConverterManager.get().convertType(value, Timestamp.class));
                break;
            }
            case -3: 
            case -2: {
                preparedStatement.setBytes(index, (byte[])TypeConverterManager.get().convertType(value, byte[].class));
                break;
            }
            default: {
                if (targetSqlType != Integer.MIN_VALUE) {
                    preparedStatement.setObject(index, value, targetSqlType);
                    break;
                }
                preparedStatement.setObject(index, value);
            }
        }
    }
}

