/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jodd.db.DbSqlException;
import jodd.util.CharUtil;
import jodd.util.StringUtil;
import jodd.util.collection.IntArrayList;

class DbQueryParser {
    public static final String SQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    boolean prepared;
    boolean callable;
    String sql;
    private Map<String, IntArrayList> namedParameterLocationMap;
    private Map<String, Integer> batchParams;

    DbQueryParser(String sql) {
        this.parseSql(sql);
    }

    private void storeNamedParameter(String name, int position) {
        IntArrayList locations = this.namedParameterLocationMap.get(name);
        if (locations == null) {
            locations = new IntArrayList();
            this.namedParameterLocationMap.put(name, locations);
        }
        locations.add(position);
    }

    IntArrayList lookupNamedParameterIndices(String name) {
        return this.namedParameterLocationMap.get(name);
    }

    IntArrayList getNamedParameterIndices(String name) {
        IntArrayList positions = this.namedParameterLocationMap.get(name);
        if (positions == null) {
            throw new DbSqlException("Named parameter not found: " + name + "\nQuery: " + this.sql);
        }
        return positions;
    }

    Iterator<String> iterateNamedParameters() {
        return this.namedParameterLocationMap.keySet().iterator();
    }

    private void saveBatchParameter(String name, int size) {
        if (this.batchParams == null) {
            this.batchParams = new HashMap<String, Integer>();
        }
        this.batchParams.put(name, size);
    }

    protected int getBatchParameterSize(String name) {
        if (this.batchParams == null) {
            return 0;
        }
        Integer size = this.batchParams.get(name);
        if (size == null) {
            return 0;
        }
        return size;
    }

    void parseSql(String sqlString) {
        this.namedParameterLocationMap = new HashMap<String, IntArrayList>();
        int stringLength = sqlString.length();
        StringBuilder pureSql = new StringBuilder(stringLength);
        boolean inQuote = false;
        int index = 0;
        int paramCount = 0;
        while (index < stringLength) {
            char c = sqlString.charAt(index);
            if (inQuote) {
                if (c == '\'') {
                    inQuote = false;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else {
                int right;
                if (c == ':') {
                    right = StringUtil.indexOfChars((String)sqlString, (String)SQL_SEPARATORS, (int)(index + 1));
                    boolean batch = false;
                    if (right < 0) {
                        right = stringLength;
                    } else if (sqlString.charAt(right) == '!') {
                        batch = true;
                    }
                    String param = sqlString.substring(index + 1, right);
                    if (!batch) {
                        this.storeNamedParameter(param, ++paramCount);
                        pureSql.append('?');
                    } else {
                        int batchSize;
                        int numStart = ++right;
                        while (right < stringLength && CharUtil.isDigit((char)sqlString.charAt(right))) {
                            ++right;
                        }
                        String numberValue = sqlString.substring(numStart, right);
                        try {
                            batchSize = Integer.parseInt(numberValue);
                        }
                        catch (NumberFormatException nfex) {
                            throw new DbSqlException("Batch size is not an integer: " + numberValue, nfex);
                        }
                        this.saveBatchParameter(param, batchSize);
                        for (int i = 1; i <= batchSize; ++i) {
                            if (i != 1) {
                                pureSql.append(',');
                            }
                            this.storeNamedParameter(param + '.' + i, ++paramCount);
                            pureSql.append('?');
                        }
                    }
                    index = right;
                    continue;
                }
                if (c == '?') {
                    if (index < stringLength - 1 && Character.isDigit(sqlString.charAt(index + 1))) {
                        right = StringUtil.indexOfChars((String)sqlString, (String)SQL_SEPARATORS, (int)(index + 1));
                        if (right < 0) {
                            right = stringLength;
                        }
                        String param = sqlString.substring(index + 1, right);
                        try {
                            Integer.parseInt(param);
                        }
                        catch (NumberFormatException nfex) {
                            throw new DbSqlException("Positional parameter is not an integer: " + param, nfex);
                        }
                        this.storeNamedParameter(param, ++paramCount);
                        pureSql.append('?');
                        index = right;
                        continue;
                    }
                    ++paramCount;
                }
            }
            pureSql.append(c);
            ++index;
        }
        this.prepared = paramCount != 0;
        this.sql = pureSql.toString();
        if (this.sql.startsWith("{")) {
            this.callable = true;
        }
    }
}

