/*
 * Decompiled with CFR 0.152.
 */
package jodd.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import jodd.cli.CliException;
import jodd.cli.Option;
import jodd.cli.Param;

public class Cli
implements Consumer<String[]> {
    private final List<Option> options = new ArrayList<Option>();
    private final List<Param> params = new ArrayList<Param>();

    public Option option() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public Param param() {
        Param param = new Param();
        this.params.add(param);
        return param;
    }

    private Option findOptionWithLongName(String longName) {
        for (Option option : this.options) {
            if (!longName.equals(option.longName)) continue;
            return option;
        }
        throw new CliException("Unknown option: " + longName);
    }

    private Option findOptionWithLongName(String longName, String valueToConsume) {
        for (Option option : this.options) {
            if (!longName.equals(option.longName)) continue;
            if (option.hasArg && valueToConsume == null) {
                throw new CliException("Option value not provided for: " + longName);
            }
            return option;
        }
        throw new CliException("Unknown option: " + longName);
    }

    private Option findOptionWithShortName(String shortName) {
        for (Option option : this.options) {
            if (!shortName.equals(option.shortName)) continue;
            return option;
        }
        throw new CliException("Unknown option: " + shortName);
    }

    private Option findOptionWithShortName(String shortName, String valueToConsume) {
        for (Option option : this.options) {
            if (!shortName.equals(option.shortName)) continue;
            if (option.hasArg && valueToConsume == null) {
                throw new CliException("Option value not provided for: " + shortName);
            }
            return option;
        }
        throw new CliException("Unknown option: " + shortName);
    }

    private Option findOptionWithShortNameAndNoArguments(String shortName) {
        for (Option option : this.options) {
            if (!shortName.equals(option.shortName) || option.hasArg) continue;
            return option;
        }
        throw new CliException("Unknown option: " + shortName);
    }

    @Override
    public void accept(String ... args) {
        boolean dontParseOptionsAnyMore = false;
        int paramsIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            String value;
            String arg = args[i];
            if (arg.isEmpty()) continue;
            String string = value = i + 1 < args.length ? args[i + 1] : null;
            if (arg.equals("--")) {
                dontParseOptionsAnyMore = true;
                continue;
            }
            if (!dontParseOptionsAnyMore) {
                Option option;
                if (arg.startsWith("--")) {
                    String argLongName = arg.substring(2);
                    option = this.findOptionWithLongName(argLongName, value);
                    option.consumer.accept(option.hasArg ? value : argLongName);
                    args[i] = null;
                    continue;
                }
                if (arg.startsWith("-")) {
                    String argShortName = arg.substring(1);
                    if (argShortName.length() > 1) {
                        char[] allShortNames;
                        for (char c : allShortNames = argShortName.toCharArray()) {
                            String argName = String.valueOf(c);
                            Option option2 = this.findOptionWithShortNameAndNoArguments(argName);
                            option2.consumer.accept(argName);
                        }
                        args[i] = null;
                        continue;
                    }
                    option = this.findOptionWithShortName(argShortName, value);
                    option.consumer.accept(option.hasArg ? value : argShortName);
                    args[i] = null;
                    continue;
                }
            }
            if (paramsIndex == this.params.size()) break;
            Param param = this.params.get(paramsIndex++);
            ArrayList<String> paramArguments = new ArrayList<String>();
            int from = 0;
            int to = param.required + param.optional;
            while (from < to) {
                String paramValue;
                String string2 = paramValue = i < args.length ? args[i] : null;
                if (paramValue == null) break;
                paramArguments.add(paramValue);
                ++from;
                ++i;
            }
            --i;
            if (paramArguments.size() < param.required) {
                throw new CliException("Parameter required: " + param.label);
            }
            if (paramArguments.isEmpty()) continue;
            param.consumer.accept(paramArguments.toArray(new String[0]));
        }
        while (paramsIndex < this.params.size()) {
            Param param = this.params.get(paramsIndex++);
            if (param.required <= 0) continue;
            throw new CliException("Parameter required: " + param.label);
        }
    }
}

