/*
 * Decompiled with CFR 0.152.
 */
package jodd.datetime.format;

import jodd.datetime.DateTimeStamp;
import jodd.datetime.JDateTime;
import jodd.datetime.format.JdtFormatter;

public abstract class AbstractFormatter
implements JdtFormatter {
    protected char[][] patterns;
    protected char escapeChar = (char)39;

    protected void preparePatterns(String[] spat) {
        this.patterns = new char[spat.length][];
        for (int i = 0; i < spat.length; ++i) {
            this.patterns[i] = spat[i].toCharArray();
        }
    }

    protected int findPattern(char[] input, int i) {
        int lastn = -1;
        int maxLen = 0;
        for (int n = 0; n < this.patterns.length; ++n) {
            char[] curr = this.patterns[n];
            if (i > input.length - curr.length) continue;
            boolean match = true;
            for (int delta = 0; delta < curr.length; ++delta) {
                if (curr[delta] == input[i + delta]) continue;
                match = false;
                break;
            }
            if (!match || this.patterns[n].length <= maxLen) continue;
            lastn = n;
            maxLen = this.patterns[n].length;
        }
        return lastn;
    }

    protected char detectSeparatorInPattern(char c) {
        for (char[] curr : this.patterns) {
            if (curr[0] != c) continue;
            return '\u0000';
        }
        return c;
    }

    protected abstract String convertPattern(int var1, JDateTime var2);

    @Override
    public String convert(JDateTime jdt, String format) {
        char[] fmtc = format.toCharArray();
        int fmtc_len = fmtc.length;
        StringBuilder result = new StringBuilder(fmtc_len);
        int i = 0;
        while (i < fmtc_len) {
            if (fmtc[i] == this.escapeChar) {
                int end;
                for (end = i + 1; end < fmtc_len; ++end) {
                    if (fmtc[end] == this.escapeChar) {
                        if (end + 1 >= fmtc_len) continue;
                        if (fmtc[++end] != this.escapeChar) break;
                        result.append(this.escapeChar);
                        continue;
                    }
                    result.append(fmtc[end]);
                }
                i = end;
                continue;
            }
            int n = this.findPattern(fmtc, i);
            if (n != -1) {
                result.append(this.convertPattern(n, jdt));
                i += this.patterns[n].length;
                continue;
            }
            result.append(fmtc[i]);
            ++i;
        }
        return result.toString();
    }

    protected abstract void parseValue(int var1, String var2, DateTimeStamp var3);

    @Override
    public DateTimeStamp parse(String value, String format) {
        char[] valueChars = value.toCharArray();
        char[] formatChars = format.toCharArray();
        int i = 0;
        int j = 0;
        int valueLen = valueChars.length;
        int formatLen = formatChars.length;
        DateTimeStamp time = new DateTimeStamp();
        StringBuilder sb = new StringBuilder(value.length());
        do {
            int n;
            if ((n = this.findPattern(formatChars, i)) != -1) {
                char separator;
                int patternLen = this.patterns[n].length;
                sb.setLength(0);
                char c = separator = (i += patternLen) < formatLen ? this.detectSeparatorInPattern(formatChars[i]) : (char)'\u0000';
                if (separator == '\u0000') {
                    for (int k = 0; k < patternLen && j < valueLen; ++k) {
                        sb.append(valueChars[j++]);
                    }
                } else {
                    ++i;
                    while (j < valueLen) {
                        char c2 = valueChars[j];
                        ++j;
                        if (c2 == separator) {
                            char cc;
                            while (j < valueLen && ((cc = valueChars[j]) == ' ' || cc == '\t')) {
                                ++j;
                            }
                            break;
                        }
                        if (c2 == ' ' || c2 == '\t') continue;
                        sb.append(c2);
                    }
                }
                this.parseValue(n, sb.toString(), time);
                continue;
            }
            if (formatChars[i] == valueChars[j]) {
                ++j;
            }
            ++i;
        } while (i != formatLen && j != valueLen);
        return time;
    }

    protected String print2(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be positive: " + value);
        }
        if (value < 10) {
            return '0' + Integer.toString(value);
        }
        if (value < 100) {
            return Integer.toString(value);
        }
        throw new IllegalArgumentException("Value too big: " + value);
    }

    protected String print3(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be positive: " + value);
        }
        if (value < 10) {
            return "00" + Integer.toString(value);
        }
        if (value < 100) {
            return '0' + Integer.toString(value);
        }
        if (value < 1000) {
            return Integer.toString(value);
        }
        throw new IllegalArgumentException("Value too big: " + value);
    }

    protected String printPad4(int value) {
        char[] result = new char[4];
        int count = 0;
        if (value < 0) {
            result[count++] = 45;
            value = -value;
        }
        String str = Integer.toString(value);
        if (value < 10) {
            result[count++] = 48;
            result[count++] = 48;
            result[count++] = 48;
            result[count++] = str.charAt(0);
        } else if (value < 100) {
            result[count++] = 48;
            result[count++] = 48;
            result[count++] = str.charAt(0);
            result[count++] = str.charAt(1);
        } else if (value < 1000) {
            result[count++] = 48;
            result[count++] = str.charAt(0);
            result[count++] = str.charAt(1);
            result[count++] = str.charAt(2);
        } else {
            if (count > 0) {
                return '-' + str;
            }
            return str;
        }
        return new String(result, 0, count);
    }
}

