/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import jodd.core.JoddCore;
import jodd.core.JoddCoreDefaults;
import jodd.util.SystemUtil;
import jodd.util.UnsafeInternal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UnsafeUtil {
    private static final boolean IS_ANDROID = SystemUtil.isHostAndroid();
    private static final boolean HAS_UNSAFE = !IS_ANDROID && UnsafeInternal.hasUnsafe();
    private static final JoddCoreDefaults JODD_CORE_DEFAULTS = JoddCore.get().defaults();

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static char[] getChars(String string) {
        if (string == null) {
            return null;
        }
        if (!HAS_UNSAFE || !JODD_CORE_DEFAULTS.isUnsafeUsed()) {
            return string.toCharArray();
        }
        return UnsafeInternal.unsafeGetChars(string);
    }
}

