/*
 * Decompiled with CFR 0.152.
 */
package jodd.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavaBridge {
    public static URL[] getURLs(Class clazz) {
        return JavaBridge.getURLs(clazz.getClassLoader(), clazz);
    }

    public static URL[] getURLs(ClassLoader classLoader) {
        return JavaBridge.getURLs(classLoader, JavaBridge.class);
    }

    private static URL[] getURLs(ClassLoader classLoader, Class clazz) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                return urlClassLoader.getURLs();
            }
            URL url = JavaBridge.classModuleUrl(classLoader, clazz);
            if (url != null) {
                urls.add(url);
            }
            classLoader = classLoader.getParent();
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL classModuleUrl(ClassLoader classLoader, Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName().replace('.', '/') + ".class";
        URL url = classLoader.getResource(name);
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        int ndx = urlString.indexOf(name);
        urlString = urlString.substring(0, ndx) + urlString.substring(ndx + name.length());
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }
}

