/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

public class CharArraySequence
implements CharSequence {
    public static final CharSequence EMPTY = CharArraySequence.of(new char[0]);
    private final char[] buffer;
    private final int off;
    private final int len;

    public static CharSequence of(char ... value) {
        return new CharArraySequence(value);
    }

    public static CharSequence from(char[] value, int offset, int len) {
        char[] buffer = new char[value.length];
        System.arraycopy(value, offset, buffer, 0, len);
        return new CharArraySequence(buffer);
    }

    public CharArraySequence(char[] value) {
        this.buffer = value;
        this.off = 0;
        this.len = value.length;
    }

    public CharArraySequence(char[] value, int offset, int length) {
        if ((offset | length | offset + length | value.length - offset - length) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = value;
        this.off = offset;
        this.len = length;
    }

    private CharArraySequence(int offset, int length, char[] value) {
        this.off = offset;
        this.len = length;
        this.buffer = value;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public String toString() {
        return String.valueOf(this.buffer, this.off, this.len);
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.off + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int count = end - start;
        int rem = this.len - end;
        if ((start | end | count | rem) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if ((start | rem) == 0) {
            return this;
        }
        return new CharArraySequence(this.off + start, count, this.buffer);
    }
}

