/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.util.ArraysUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;
import jodd.util.cl.ClassLoaderStrategy;

public class ClassUtil {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String METHOD_GET_PREFIX = "get";
    public static final String METHOD_IS_PREFIX = "is";
    public static final String METHOD_SET_PREFIX = "set";
    private static Method _getMethod0;
    private static ReflectUtilSecurityManager SECURITY_MANAGER;

    public static Method getMethod0(Class c, String name, Class ... parameterTypes) {
        try {
            return (Method)_getMethod0.invoke((Object)c, name, parameterTypes);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static Method findMethod(Class c, String methodName) {
        return ClassUtil.findDeclaredMethod(c, methodName, true);
    }

    public static Method findDeclaredMethod(Class c, String methodName) {
        return ClassUtil.findDeclaredMethod(c, methodName, false);
    }

    private static Method findDeclaredMethod(Class c, String methodName, boolean publicOnly) {
        Method[] ms;
        if (methodName == null || c == null) {
            return null;
        }
        for (Method m : ms = publicOnly ? c.getMethods() : c.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isAllAssignableFrom(Class<?>[] typesTarget, Class<?>[] typesFrom) {
        if (typesTarget.length == typesFrom.length) {
            for (int i = 0; i < typesTarget.length; ++i) {
                if (typesTarget[i].isAssignableFrom(typesFrom[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Class[] getClasses(Object ... objects) {
        if (objects.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            result[i] = objects[i].getClass();
        }
        return result;
    }

    public static boolean isTypeOf(Class<?> lookupClass, Class<?> targetClass) {
        if (targetClass == null || lookupClass == null) {
            return false;
        }
        return targetClass.isAssignableFrom(lookupClass);
    }

    public static boolean isInstanceOf(Object object, Class target) {
        if (object == null || target == null) {
            return false;
        }
        return target.isInstance(object);
    }

    public static Class[] resolveAllInterfaces(Class type) {
        LinkedHashSet<Class> bag = new LinkedHashSet<Class>();
        ClassUtil._resolveAllInterfaces(type, bag);
        return bag.toArray(new Class[bag.size()]);
    }

    private static void _resolveAllInterfaces(Class type, Set<Class> bag) {
        Class<?>[] interfaces = type.getInterfaces();
        Collections.addAll(bag, interfaces);
        for (Class<?> iface : interfaces) {
            ClassUtil._resolveAllInterfaces(iface, bag);
        }
        Class superClass = type.getSuperclass();
        if (superClass == null) {
            return;
        }
        if (superClass == Object.class) {
            return;
        }
        ClassUtil._resolveAllInterfaces(type.getSuperclass(), bag);
    }

    public static Class[] resolveAllSuperclasses(Class type) {
        ArrayList list = new ArrayList();
        while ((type = type.getSuperclass()) != null && type != Object.class) {
            list.add(type);
        }
        return list.toArray(new Class[list.size()]);
    }

    public static Method[] getAccessibleMethods(Class clazz) {
        return ClassUtil.getAccessibleMethods(clazz, Object.class);
    }

    public static Method[] getAccessibleMethods(Class clazz, Class limit) {
        Package topPackage = clazz.getPackage();
        ArrayList<Method> methodList = new ArrayList<Method>();
        int topPackageHash = topPackage == null ? 0 : topPackage.hashCode();
        boolean top = true;
        while (clazz != null) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                int pckgHash;
                if (Modifier.isVolatile(method.getModifiers())) continue;
                if (top) {
                    methodList.add(method);
                    continue;
                }
                int modifier = method.getModifiers();
                if (Modifier.isPrivate(modifier) || Modifier.isAbstract(modifier)) continue;
                if (Modifier.isPublic(modifier)) {
                    ClassUtil.addMethodIfNotExist(methodList, method);
                    continue;
                }
                if (Modifier.isProtected(modifier)) {
                    ClassUtil.addMethodIfNotExist(methodList, method);
                    continue;
                }
                Package pckg = method.getDeclaringClass().getPackage();
                int n = pckgHash = pckg == null ? 0 : pckg.hashCode();
                if (pckgHash != topPackageHash) continue;
                ClassUtil.addMethodIfNotExist(methodList, method);
            }
            top = false;
            if ((clazz = clazz.getSuperclass()) != limit) continue;
        }
        Method[] methods = new Method[methodList.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)methodList.get(i);
        }
        return methods;
    }

    private static void addMethodIfNotExist(List<Method> allMethods, Method newMethod) {
        for (Method m : allMethods) {
            if (!ClassUtil.compareSignatures(m, newMethod)) continue;
            return;
        }
        allMethods.add(newMethod);
    }

    public static Field[] getAccessibleFields(Class clazz) {
        return ClassUtil.getAccessibleFields(clazz, Object.class);
    }

    public static Field[] getAccessibleFields(Class clazz, Class limit) {
        Package topPackage = clazz.getPackage();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int topPackageHash = topPackage == null ? 0 : topPackage.hashCode();
        boolean top = true;
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                int pckgHash;
                if (top) {
                    fieldList.add(field);
                    continue;
                }
                int modifier = field.getModifiers();
                if (Modifier.isPrivate(modifier)) continue;
                if (Modifier.isPublic(modifier)) {
                    ClassUtil.addFieldIfNotExist(fieldList, field);
                    continue;
                }
                if (Modifier.isProtected(modifier)) {
                    ClassUtil.addFieldIfNotExist(fieldList, field);
                    continue;
                }
                Package pckg = field.getDeclaringClass().getPackage();
                int n = pckgHash = pckg == null ? 0 : pckg.hashCode();
                if (pckgHash != topPackageHash) continue;
                ClassUtil.addFieldIfNotExist(fieldList, field);
            }
            top = false;
            if ((clazz = clazz.getSuperclass()) != limit) continue;
        }
        Field[] fields = new Field[fieldList.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (Field)fieldList.get(i);
        }
        return fields;
    }

    private static void addFieldIfNotExist(List<Field> allFields, Field newField) {
        for (Field f : allFields) {
            if (!ClassUtil.compareSignatures(f, newField)) continue;
            return;
        }
        allFields.add(newField);
    }

    public static Method[] getSupportedMethods(Class clazz) {
        return ClassUtil.getSupportedMethods(clazz, Object.class);
    }

    public static Method[] getSupportedMethods(Class clazz, Class limit) {
        ArrayList<Method> supportedMethods = new ArrayList<Method>();
        for (Class c = clazz; c != limit; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                boolean found = false;
                for (Method supportedMethod : supportedMethods) {
                    if (!ClassUtil.compareSignatures(method, supportedMethod)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                supportedMethods.add(method);
            }
        }
        return supportedMethods.toArray(new Method[supportedMethods.size()]);
    }

    public static Field[] getSupportedFields(Class clazz) {
        return ClassUtil.getSupportedFields(clazz, Object.class);
    }

    public static Field[] getSupportedFields(Class clazz, Class limit) {
        ArrayList<Field> supportedFields = new ArrayList<Field>();
        for (Class c = clazz; c != limit; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                boolean found = false;
                for (Field supportedField : supportedFields) {
                    if (!ClassUtil.compareSignatures(field, supportedField)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                supportedFields.add(field);
            }
        }
        return supportedFields.toArray(new Field[supportedFields.size()]);
    }

    public static boolean compareDeclarations(Method first, Method second) {
        if (first.getReturnType() != second.getReturnType()) {
            return false;
        }
        return ClassUtil.compareSignatures(first, second);
    }

    public static boolean compareSignatures(Method first, Method second) {
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        return ClassUtil.compareParameters(first.getParameterTypes(), second.getParameterTypes());
    }

    public static boolean compareSignatures(Constructor first, Constructor second) {
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        return ClassUtil.compareParameters(first.getParameterTypes(), second.getParameterTypes());
    }

    public static boolean compareSignatures(Field first, Field second) {
        return first.getName().equals(second.getName());
    }

    public static boolean compareParameters(Class[] first, Class[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static void forceAccess(AccessibleObject accObject) {
        if (accObject.isAccessible()) {
            return;
        }
        try {
            accObject.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublicPublic(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    public static boolean isPublic(Class c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (params.length == 0) {
            return ClassUtil.newInstance(clazz);
        }
        Class[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ClassUtil.findConstructor(clazz, paramTypes);
        if (constructor == null) {
            throw new InstantiationException("No constructor matched parameter types.");
        }
        return constructor.newInstance(params);
    }

    public static <T> T newInstance(Class<T> type) throws IllegalAccessException, InstantiationException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            throw new IllegalArgumentException("Invalid primitive: " + type);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(0);
        }
        if (type == String.class) {
            return (T)"";
        }
        if (type == Long.class) {
            return (T)Long.valueOf(0L);
        }
        if (type == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        if (type == Float.class) {
            return (T)Float.valueOf(0.0f);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(0.0);
        }
        if (type == Map.class) {
            return (T)new HashMap();
        }
        if (type == List.class) {
            return (T)new ArrayList();
        }
        if (type == Set.class) {
            return (T)new HashSet();
        }
        if (type == Collection.class) {
            return (T)new ArrayList();
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf((byte)0);
        }
        if (type == Short.class) {
            return (T)Short.valueOf((short)0);
        }
        if (type == Character.class) {
            return (T)Character.valueOf('\u0000');
        }
        if (type.isEnum()) {
            return type.getEnumConstants()[0];
        }
        if (type.isArray()) {
            return (T)Array.newInstance(type.getComponentType(), 0);
        }
        return type.newInstance();
    }

    public static boolean isAssignableFrom(Member member1, Member member2) {
        return member1.getDeclaringClass().isAssignableFrom(member2.getDeclaringClass());
    }

    public static Class[] getSuperclasses(Class type) {
        int i = 0;
        for (Class x = type.getSuperclass(); x != null; x = x.getSuperclass()) {
            ++i;
        }
        Class[] result = new Class[i];
        i = 0;
        for (Class x = type.getSuperclass(); x != null; x = x.getSuperclass()) {
            result[i] = x;
            ++i;
        }
        return result;
    }

    public static boolean isUserDefinedMethod(Method method) {
        return method.getDeclaringClass() != Object.class;
    }

    public static boolean isObjectMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }

    public static boolean isBeanProperty(Method method) {
        if (ClassUtil.isObjectMethod(method)) {
            return false;
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        return methodName.startsWith(METHOD_GET_PREFIX) ? returnType != null && paramTypes.length == 0 : (methodName.startsWith(METHOD_IS_PREFIX) ? returnType != null && paramTypes.length == 0 : methodName.startsWith(METHOD_SET_PREFIX) && paramTypes.length == 1);
    }

    public static boolean isBeanPropertyGetter(Method method) {
        return ClassUtil.getBeanPropertyGetterPrefixLength(method) != 0;
    }

    private static int getBeanPropertyGetterPrefixLength(Method method) {
        if (ClassUtil.isObjectMethod(method)) {
            return 0;
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith(METHOD_GET_PREFIX)) {
            if (returnType != null && paramTypes.length == 0) {
                return 3;
            }
        } else if (methodName.startsWith(METHOD_IS_PREFIX) && returnType != null && paramTypes.length == 0) {
            return 2;
        }
        return 0;
    }

    public static String getBeanPropertyGetterName(Method method) {
        int prefixLength = ClassUtil.getBeanPropertyGetterPrefixLength(method);
        if (prefixLength == 0) {
            return null;
        }
        String methodName = method.getName().substring(prefixLength);
        return StringUtil.decapitalize(methodName);
    }

    public static boolean isBeanPropertySetter(Method method) {
        return ClassUtil.getBeanPropertySetterPrefixLength(method) != 0;
    }

    private static int getBeanPropertySetterPrefixLength(Method method) {
        if (ClassUtil.isObjectMethod(method)) {
            return 0;
        }
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith(METHOD_SET_PREFIX) && paramTypes.length == 1) {
            return 3;
        }
        return 0;
    }

    public static String getBeanPropertySetterName(Method method) {
        int prefixLength = ClassUtil.getBeanPropertySetterPrefixLength(method);
        if (prefixLength == 0) {
            return null;
        }
        String methodName = method.getName().substring(prefixLength);
        return StringUtil.decapitalize(methodName);
    }

    public static Class getComponentType(Type type, int index) {
        return ClassUtil.getComponentType(type, null, index);
    }

    public static Class getComponentType(Type type, Class implClass, int index) {
        Class[] componentTypes = ClassUtil.getComponentTypes(type, implClass);
        if (componentTypes == null) {
            return null;
        }
        if (index < 0) {
            index += componentTypes.length;
        }
        if (index >= componentTypes.length) {
            return null;
        }
        return componentTypes[index];
    }

    public static Class[] getComponentTypes(Type type) {
        return ClassUtil.getComponentTypes(type, null);
    }

    public static Class[] getComponentTypes(Type type, Class implClass) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return new Class[]{clazz.getComponentType()};
            }
        } else {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type[] generics = pt.getActualTypeArguments();
                if (generics.length == 0) {
                    return null;
                }
                Class[] types = new Class[generics.length];
                for (int i = 0; i < generics.length; ++i) {
                    types[i] = ClassUtil.getRawType(generics[i], implClass);
                }
                return types;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)type;
                Class<?> rawType = ClassUtil.getRawType(gat.getGenericComponentType(), implClass);
                if (rawType == null) {
                    return null;
                }
                return new Class[]{rawType};
            }
        }
        return null;
    }

    public static Class[] getGenericSupertypes(Class type) {
        return ClassUtil.getComponentTypes(type.getGenericSuperclass());
    }

    public static Class getGenericSupertype(Class type, int index) {
        return ClassUtil.getComponentType(type.getGenericSuperclass(), index);
    }

    public static Class getRawType(Type type) {
        return ClassUtil.getRawType(type, null);
    }

    public static Class<?> getRawType(Type type, Class implClass) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return ClassUtil.getRawType(pType.getRawType(), implClass);
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            Type[] lowerTypes = wType.getLowerBounds();
            if (lowerTypes.length > 0) {
                return ClassUtil.getRawType(lowerTypes[0], implClass);
            }
            Type[] upperTypes = wType.getUpperBounds();
            if (upperTypes.length != 0) {
                return ClassUtil.getRawType(upperTypes[0], implClass);
            }
            return Object.class;
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> rawType = ClassUtil.getRawType(genericComponentType, implClass);
            return Array.newInstance(rawType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            Type resolvedType;
            TypeVariable varType = (TypeVariable)type;
            if (implClass != null && (resolvedType = ClassUtil.resolveVariable(varType, implClass)) != null) {
                return ClassUtil.getRawType(resolvedType, null);
            }
            Type[] boundsTypes = varType.getBounds();
            if (boundsTypes.length == 0) {
                return Object.class;
            }
            return ClassUtil.getRawType(boundsTypes[0], implClass);
        }
        return null;
    }

    public static Type resolveVariable(TypeVariable variable, Class implClass) {
        Class<?> rawType = ClassUtil.getRawType(implClass, null);
        int index = ArraysUtil.indexOf(rawType.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] interfaces = rawType.getInterfaces();
        Type[] genericInterfaces = rawType.getGenericInterfaces();
        for (int i = 0; i <= interfaces.length; ++i) {
            Type type;
            Class<?> rawInterface;
            if (i < interfaces.length) {
                rawInterface = interfaces[i];
            } else {
                rawInterface = rawType.getSuperclass();
                if (rawInterface == null) continue;
            }
            Type resolved = ClassUtil.resolveVariable(variable, rawInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArraysUtil.indexOf(rawInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                throw new IllegalArgumentException("Invalid type variable:" + typeVariable);
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : rawType.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[index];
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return null;
    }

    public static String typeToString(Type type) {
        StringBuilder sb = new StringBuilder();
        ClassUtil.typeToString(sb, type, new HashSet<Type>());
        return sb.toString();
    }

    private static void typeToString(StringBuilder sb, Type type, Set<Type> visited) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            sb.append(rawType.getName());
            boolean first = true;
            for (Type typeArg : parameterizedType.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append('<');
                ClassUtil.typeToString(sb, typeArg, visited);
                sb.append('>');
            }
        } else if (type instanceof WildcardType) {
            Type bound;
            WildcardType wildcardType = (WildcardType)type;
            sb.append('?');
            if (wildcardType.getLowerBounds().length != 0) {
                sb.append(" super ");
                bound = wildcardType.getLowerBounds()[0];
            } else {
                sb.append(" extends ");
                bound = wildcardType.getUpperBounds()[0];
            }
            ClassUtil.typeToString(sb, bound, visited);
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            sb.append(typeVariable.getName());
            if (!visited.contains(type)) {
                visited.add(type);
                sb.append(" extends ");
                boolean first = true;
                for (Type bound : typeVariable.getBounds()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" & ");
                    }
                    ClassUtil.typeToString(sb, bound, visited);
                }
                visited.remove(type);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            ClassUtil.typeToString(genericArrayType.getGenericComponentType());
            sb.append(genericArrayType.getGenericComponentType());
            sb.append("[]");
        } else if (type instanceof Class) {
            Class typeClass = (Class)type;
            sb.append(typeClass.getName());
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }

    public static Object readAnnotationValue(Annotation annotation, String name) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static Class getCallerClass(int framesToSkip) {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER.getCallerClass(framesToSkip);
        }
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        if (framesToSkip >= 2) {
            framesToSkip += 4;
        }
        String className = stackTraceElements[framesToSkip].getClassName();
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfex) {
            throw new UnsupportedOperationException(className + " not found.");
        }
    }

    public static Class getCallerClass() {
        StackTraceElement[] stackTraceElements;
        String className = null;
        for (StackTraceElement stackTraceElement : stackTraceElements = new Throwable().getStackTrace()) {
            className = stackTraceElement.getClassName();
            String methodName = stackTraceElement.getMethodName();
            if (!(methodName.equals("loadClass") ? className.contains(ClassLoaderStrategy.class.getSimpleName()) || className.equals(ClassLoaderUtil.class.getName()) : methodName.equals("getCallerClass"))) break;
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfex) {
            throw new UnsupportedOperationException(className + " not found.");
        }
    }

    public static Class findEnum(Class target) {
        if (target.isPrimitive()) {
            return null;
        }
        while (target != Object.class) {
            if (target.isEnum()) {
                return target;
            }
            target = target.getSuperclass();
        }
        return null;
    }

    static {
        try {
            _getMethod0 = Class.class.getDeclaredMethod("getMethod0", String.class, Class[].class);
            _getMethod0.setAccessible(true);
        }
        catch (Exception ignore) {
            try {
                _getMethod0 = Class.class.getMethod("getMethod", String.class, Class[].class);
            }
            catch (Exception ignored) {
                _getMethod0 = null;
            }
        }
        try {
            SECURITY_MANAGER = new ReflectUtilSecurityManager();
        }
        catch (Exception ex) {
            SECURITY_MANAGER = null;
        }
    }

    private static class ReflectUtilSecurityManager
    extends SecurityManager {
        private ReflectUtilSecurityManager() {
        }

        public Class getCallerClass(int callStackDepth) {
            return this.getClassContext()[callStackDepth + 1];
        }
    }
}

