/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap
extends AbstractMap
implements Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Invalid initial capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Invalid load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(101, 0.75f);
    }

    public IntHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Number) {
            return this.containsKey(((Number)key).intValue());
        }
        return false;
    }

    public boolean containsKey(int key) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof Number) {
            return this.get(((Number)key).intValue());
        }
        return null;
    }

    public Object get(int key) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = (oldCapacity << 1) + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    @Override
    public Object put(Object key, Object value) {
        if (key instanceof Number) {
            return this.put(((Number)key).intValue(), value);
        }
        throw new UnsupportedOperationException("IntHashMap key must be a Number");
    }

    @Override
    public Object put(int key, Object value) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(key, value, tab[index]);
        ++this.count;
        return null;
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof Number) {
            return this.remove(((Number)key).intValue());
        }
        return null;
    }

    public Object remove(int key) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void putAll(Map t) {
        Iterator iterator = t.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    @Override
    public IntHashMap clone() {
        try {
            IntHashMap t = (IntHashMap)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return new IntHashIterator(0);
                }

                @Override
                public int size() {
                    return IntHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return IntHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return IntHashMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    IntHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new IntHashIterator(1);
                }

                @Override
                public int size() {
                    return IntHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return IntHashMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    IntHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new IntHashIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = IntHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    while (e != null) {
                        if (e.key == hash && e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = IntHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        if (e.key == hash && e.equals(entry)) {
                            IntHashMap.this.modCount++;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            IntHashMap.this.count--;
                            e.value = null;
                            return true;
                        }
                        prev = e;
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return IntHashMap.this.count;
                }

                @Override
                public void clear() {
                    IntHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private class IntHashIterator
    implements Iterator {
        Entry[] _table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        IntHashIterator(int type) {
            this._table = IntHashMap.this.table;
            this.index = this._table.length;
            this.expectedModCount = IntHashMap.this.modCount;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            while (this.entry == null && this.index > 0) {
                this.entry = this._table[--this.index];
            }
            return this.entry != null;
        }

        public Object next() {
            if (IntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            while (this.entry == null && this.index > 0) {
                this.entry = this._table[--this.index];
            }
            if (this.entry != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.getKey() : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IntHashMap.this.table;
            int ndx = (this.lastReturned.key & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[ndx];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    IntHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[ndx] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    IntHashMap.this.count--;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    implements Map.Entry<Integer, Object>,
    Cloneable {
        int key;
        Object value;
        Entry next;
        private Integer objectKey;

        Entry(int key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public Integer getKey() {
            return this.objectKey != null ? this.objectKey : (this.objectKey = Integer.valueOf(this.key));
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getKey().equals(e.getKey()) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return Integer.toString(this.key) + '=' + this.value;
        }
    }
}

