/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamGobbler;
import jodd.util.StringBand;
import jodd.util.SystemUtil;

public class CommandLine {
    public static final String ERROR_TYPE = "error";
    public static final String OUTPUT_TYPE = "output";
    public static final String CMD = "cmd";
    public static final String OPEN = "open";
    public static final String SH = "sh";
    public static final String SHC = "sh -c";
    public static final int OK = 0;
    protected final List<String> commands = new ArrayList<String>();
    protected File workingDirectory;

    protected CommandLine(String command) {
        this.resolveExecutor(command);
        this.commands.add(command);
    }

    public static CommandLine cmd(String command) {
        return new CommandLine(command);
    }

    public CommandLine setWorkingDirectory(File workDirectory) {
        this.workingDirectory = workDirectory;
        return this;
    }

    public CommandLine setWorkingDirectory(String workDirectory) {
        this.workingDirectory = new File(workDirectory);
        return this;
    }

    public CommandLine addArgument(String argument) {
        this.commands.add(argument);
        return this;
    }

    public CommandLine addArguments(String ... arguments) {
        if (arguments != null && arguments.length > 0) {
            for (String argument : arguments) {
                this.commands.add(argument);
            }
        }
        return this;
    }

    protected void resolveExecutor(String command) {
        File commandFile = new File(command);
        if (SystemUtil.isHostMac()) {
            if (this.isSH(command)) {
                this.commands.add(SH);
            } else if (!commandFile.canExecute() || FileNameUtil.hasExtension(commandFile.getAbsolutePath())) {
                if (FileUtil.isExistingFile(commandFile)) {
                    this.commands.add(OPEN);
                } else {
                    this.commands.add(SHC);
                }
            }
        } else if (SystemUtil.isHostAix() || SystemUtil.isHostLinux() || SystemUtil.isHostSolaris() || SystemUtil.isHostUnix()) {
            this.commands.add(SH);
            this.commands.add("-c");
        } else if (SystemUtil.isHostWindows()) {
            this.commands.add(CMD);
            this.commands.add("/c");
        }
    }

    protected boolean isSH(String command) {
        return FileNameUtil.getExtension(command).equals(SH);
    }

    public int execute() throws IOException, InterruptedException {
        return this.execute(OUTPUT_TYPE);
    }

    public int execute(String outputType) throws IOException, InterruptedException {
        return this.execute(outputType, ERROR_TYPE);
    }

    public int execute(String outputType, String errorType) throws IOException, InterruptedException {
        return this.execute(outputType, errorType, System.out, System.out);
    }

    public int execute(String outputType, String errorType, OutputStream out, OutputStream error) throws IOException, InterruptedException {
        String[] commandsArray = this.commands.toArray(new String[this.commands.size()]);
        StringBand commandLine = new StringBand(commandsArray.length * 2);
        for (String command : commandsArray) {
            commandLine.append(command);
            commandLine.append(" ");
        }
        Process process = Runtime.getRuntime().exec(commandLine.toString().trim(), null, this.workingDirectory);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), errorType, error);
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), outputType, out);
        int exitCode = process.waitFor();
        outputGobbler.start();
        errorGobbler.start();
        return exitCode;
    }
}

